/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.image.manager.transformer;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import one.jpro.platform.image.manager.transformer.ImageTransformer;
import one.jpro.platform.image.manager.transformer.ImageTransformerHelpers;
import org.json.JSONObject;

public class ImageTransformerFitWidth
implements ImageTransformer {
    private final int targetWidth;

    public ImageTransformerFitWidth(int targetWidth) {
        this.targetWidth = targetWidth;
    }

    public ImageTransformerFitWidth(int targetWidth, int devicePixelRatio) {
        this.targetWidth = targetWidth * devicePixelRatio;
    }

    @Override
    public BufferedImage transform(BufferedImage inputImage) {
        int originalWidth = inputImage.getWidth();
        int originalHeight = inputImage.getHeight();
        double aspectRatio = (double)originalHeight / (double)originalWidth;
        int targetHeight = (int)((double)this.targetWidth * aspectRatio);
        BufferedImage outputImage = new BufferedImage(this.targetWidth, targetHeight, inputImage.getType());
        Graphics2D g2d = (Graphics2D)outputImage.getGraphics();
        ImageTransformerHelpers.graphicsDefaultConfiguration(g2d);
        g2d.drawImage(inputImage, 0, 0, this.targetWidth, targetHeight, null);
        g2d.dispose();
        return outputImage;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("type", (Object)this.getClass().getSimpleName());
        json.put("targetWidth", this.targetWidth);
        return json;
    }
}

