/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandRunner {
    private final Logger logger;
    private final List<String> args = new ArrayList<String>();
    private final Map<String, String> envVars = new HashMap<String, String>();
    private final List<String> secretArgs = new ArrayList<String>();
    private final StringBuffer processOutput = new StringBuffer();
    private boolean interactive = false;
    private boolean printToConsole = false;

    public CommandRunner(String ... args) {
        this(LoggerFactory.getLogger(CommandRunner.class), args);
    }

    public CommandRunner(Logger logger, String ... args) {
        this.logger = logger;
        Collections.addAll(this.args, args);
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public void setPrintToConsole(boolean printToConsole) {
        this.printToConsole = printToConsole;
    }

    public void addArg(@NotNull String arg) {
        this.args.add(arg);
    }

    public void addSecretArg(@Nullable String arg) {
        this.secretArgs.add(arg);
        this.args.add(arg);
    }

    public void addArgs(String ... args) {
        this.args.addAll(Arrays.asList(args));
    }

    public void addArgs(@NotNull Collection<String> args) {
        this.args.addAll(args);
    }

    public String getCmd() {
        return String.join((CharSequence)" ", this.args);
    }

    public List<String> getCmdList() {
        return this.args;
    }

    public void addToEnv(@NotNull String key, @NotNull String value) {
        this.envVars.put(key, value);
    }

    public int run(@Nullable String processName) throws IOException, InterruptedException {
        return this.run(processName, null);
    }

    public int run(@Nullable String processName, @Nullable File workingDirectory) throws IOException, InterruptedException {
        Process process = this.setupProcess(processName, workingDirectory);
        Thread mergeOutputThread = this.mergeProcessOutput(process.getInputStream());
        int result = process.waitFor();
        mergeOutputThread.join();
        this.logger.debug("Result for {}: {}", (Object)processName, (Object)result);
        if (result != 0) {
            this.logger.error("Process {} failed with result: {}", (Object)processName, (Object)result);
        }
        return result;
    }

    public Process runAsync(@Nullable String processName) throws IOException {
        return this.runAsync(processName, null, true);
    }

    public Process runAsync(@Nullable String processName, @Nullable File workingDirectory) throws IOException {
        return this.runAsync(processName, workingDirectory, true);
    }

    public Process runAsync(@Nullable String processName, boolean mergeOutput) throws IOException {
        return this.runAsync(processName, null, mergeOutput);
    }

    public Process runAsync(@Nullable String processName, @Nullable File workingDirectory, boolean mergeOutput) throws IOException {
        Process process = this.setupProcess(processName, workingDirectory);
        if (mergeOutput) {
            this.mergeProcessOutput(process.getInputStream());
        }
        return process;
    }

    public boolean runTimed(@Nullable String processName, long timeout) throws IOException, InterruptedException {
        return this.runTimed(processName, null, timeout);
    }

    public boolean runTimed(@Nullable String processName, @Nullable File workingDirectory, long timeout) throws IOException, InterruptedException {
        Process process = this.setupProcess(processName, workingDirectory);
        Thread logThread = this.mergeProcessOutput(process.getInputStream());
        boolean result = process.waitFor(timeout, TimeUnit.SECONDS);
        logThread.join();
        this.logger.debug("Result for {}: {}", (Object)processName, (Object)result);
        if (!result) {
            this.logger.error("Process {} failed with result: {}", (Object)processName, (Object)result);
        }
        return result;
    }

    @Nullable
    public String getResponse() {
        return this.processOutput.length() > 0 ? this.processOutput.toString().replaceAll("\n", "") : null;
    }

    @NotNull
    public List<String> getResponses() {
        return this.processOutput.length() > 0 ? Arrays.asList(this.processOutput.toString().split("\n")) : Collections.emptyList();
    }

    public String getLastResponse() {
        String[] responses = this.processOutput.toString().split("\n");
        return responses.length > 0 ? responses[responses.length - 1] : "";
    }

    private Process setupProcess(String processName, File directory) throws IOException {
        if (this.args.isEmpty()) {
            throw new IllegalArgumentException("No command line arguments provided");
        }
        ProcessBuilder pb = new ProcessBuilder(this.args).redirectErrorStream(true);
        if (this.interactive) {
            pb.inheritIO();
        }
        if (directory != null) {
            pb.directory(directory);
        }
        this.envVars.forEach(pb.environment()::put);
        this.processOutput.setLength(0);
        String sanitizedCmd = this.args.stream().map(arg -> this.secretArgs.contains(arg) ? arg.charAt(0) + "******" : arg).collect(Collectors.joining(" "));
        this.logger.debug("Command for {}: {}", (Object)processName, (Object)sanitizedCmd);
        return pb.start();
    }

    private Thread mergeProcessOutput(InputStream inputStream) {
        Thread thread = new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                reader.lines().forEach(line -> {
                    this.processOutput.append((String)line).append("\n");
                    if (this.printToConsole) {
                        System.out.println((String)line);
                    }
                    this.logger.debug(line);
                });
            }
            catch (IOException ex) {
                this.logger.error("Error reading process output", (Throwable)ex);
            }
        });
        thread.start();
        return thread;
    }
}

