/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.mail.impl;

import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import one.jpro.platform.mail.MailException;
import one.jpro.platform.mail.MailMessage;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;

public class MailMessageImpl
implements MailMessage {
    private final Message message;
    private final Multipart multipart;

    MailMessageImpl(Session session) {
        this.message = new MimeMessage(session);
        this.multipart = new MimeMultipart();
    }

    @Override
    public ImmutableList<String> getFrom() {
        ImmutableList fromAddresses;
        try {
            Object[] addresses = this.message.getFrom();
            fromAddresses = Lists.immutable.of(addresses).collect(Address::toString);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to get the addresses from the \"From\" attribute in this message", ex);
        }
        return fromAddresses;
    }

    @Override
    public void setFrom(String address) {
        try {
            this.message.setFrom((Address)new InternetAddress(address));
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to set the address to the \"From\" attribute in this message", ex);
        }
    }

    @Override
    public void addFrom(ImmutableList<String> addresses) {
        try {
            InternetAddress[] fromAddresses = new InternetAddress[addresses.size()];
            for (int i = 0; i < addresses.size(); ++i) {
                fromAddresses[i] = new InternetAddress((String)addresses.get(i));
            }
            this.message.addFrom((Address[])fromAddresses);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to add the addresses to the existing \"From\" attribute in this message", ex);
        }
    }

    @Override
    public ImmutableList<String> getTo() {
        ImmutableList toAddresses;
        try {
            Object[] addresses = this.message.getRecipients(Message.RecipientType.TO);
            toAddresses = Lists.immutable.of(addresses).collect(Address::toString);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to get the addresses from the \"To\" attribute in this message", ex);
        }
        return toAddresses;
    }

    @Override
    public void setTo(String address) {
        this.setTo((ImmutableList<String>)Lists.immutable.of((Object)address));
    }

    @Override
    public void setTo(ImmutableList<String> addresses) {
        try {
            InternetAddress[] toAddresses = new InternetAddress[addresses.size()];
            for (int i = 0; i < addresses.size(); ++i) {
                toAddresses[i] = new InternetAddress((String)addresses.get(i));
            }
            this.message.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to set the addresses to the \"To\" attribute in this message", ex);
        }
    }

    @Override
    public void addTo(ImmutableList<String> addresses) {
        try {
            InternetAddress[] toAddresses = new InternetAddress[addresses.size()];
            for (int i = 0; i < addresses.size(); ++i) {
                toAddresses[i] = new InternetAddress((String)addresses.get(i));
            }
            this.message.addRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to add the addresses to the existing \"To\" attribute in this message", ex);
        }
    }

    @Override
    public ImmutableList<String> getCc() {
        ImmutableList ccAddresses;
        try {
            Object[] addresses = this.message.getRecipients(Message.RecipientType.CC);
            ccAddresses = Lists.immutable.of(addresses).collect(Address::toString);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to get the addresses from the \"Cc\" attribute in this message", ex);
        }
        return ccAddresses;
    }

    @Override
    public void setCc(ImmutableList<String> addresses) {
        try {
            InternetAddress[] ccAddresses = new InternetAddress[addresses.size()];
            for (int i = 0; i < addresses.size(); ++i) {
                ccAddresses[i] = new InternetAddress((String)addresses.get(i));
            }
            this.message.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to set the addresses to the \"Cc\" attribute in this message", ex);
        }
    }

    @Override
    public void addCc(ImmutableList<String> addresses) {
        try {
            InternetAddress[] ccAddresses = new InternetAddress[addresses.size()];
            for (int i = 0; i < addresses.size(); ++i) {
                ccAddresses[i] = new InternetAddress((String)addresses.get(i));
            }
            this.message.addRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to add the addresses to the existing \"Cc\" attribute in this message", ex);
        }
    }

    @Override
    public ImmutableList<String> getBcc() {
        ImmutableList bccAddresses;
        try {
            Object[] addresses = this.message.getRecipients(Message.RecipientType.BCC);
            bccAddresses = Lists.immutable.of(addresses).collect(Address::toString);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to get the addresses from the \"Bcc\" attribute in this message", ex);
        }
        return bccAddresses;
    }

    @Override
    public void setBcc(ImmutableList<String> addresses) {
        try {
            InternetAddress[] bccAddresses = new InternetAddress[addresses.size()];
            for (int i = 0; i < addresses.size(); ++i) {
                bccAddresses[i] = new InternetAddress((String)addresses.get(i));
            }
            this.message.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to set the addresses to the \"Bcc\" attribute in this message", ex);
        }
    }

    @Override
    public void addBcc(ImmutableList<String> addresses) {
        try {
            InternetAddress[] bccAddresses = new InternetAddress[addresses.size()];
            for (int i = 0; i < addresses.size(); ++i) {
                bccAddresses[i] = new InternetAddress((String)addresses.get(i));
            }
            this.message.addRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to add the addresses to the existing \"Bcc\" attribute in this message", ex);
        }
    }

    @Override
    public ImmutableList<String> getAllRecipients() {
        ImmutableList allRecipients;
        try {
            Object[] addresses = this.message.getAllRecipients();
            allRecipients = Lists.immutable.of(addresses).collect(Address::toString);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to get all the recipients for this message", ex);
        }
        return allRecipients;
    }

    @Override
    public ImmutableList<String> getReplyTo() {
        ImmutableList replyToAddresses;
        try {
            Object[] addresses = this.message.getReplyTo();
            replyToAddresses = Lists.immutable.of(addresses).collect(Address::toString);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to get the addresses from the \"Reply-To\" attribute in this message", ex);
        }
        return replyToAddresses;
    }

    @Override
    public void setReplyTo(ImmutableList<String> addresses) {
        try {
            InternetAddress[] replyToAddresses = new InternetAddress[addresses.size()];
            for (int i = 0; i < addresses.size(); ++i) {
                replyToAddresses[i] = new InternetAddress((String)addresses.get(i));
            }
            this.message.setReplyTo((Address[])replyToAddresses);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to set the addresses to the \"Reply-To\" attribute in this message", ex);
        }
    }

    @Override
    public String getSubject() {
        try {
            return this.message.getSubject();
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to get the subject from this message", ex);
        }
    }

    @Override
    public void setSubject(String subject) {
        try {
            this.message.setSubject(subject);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to set the subject to this message", ex);
        }
    }

    @Override
    public void setText(String text) {
        try {
            this.message.setText(text);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to set the text to this message", ex);
        }
    }

    @Override
    public void setHtml(String htmlText) {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)htmlText, "text/html; charset=utf-8");
            this.multipart.addBodyPart((BodyPart)mimeBodyPart);
            this.message.setContent(this.multipart);
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to set the HTML content to this message", ex);
        }
    }

    @Override
    public void addAttachment(File file) {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.attachFile(file);
            this.multipart.addBodyPart((BodyPart)mimeBodyPart);
            this.message.setContent(this.multipart);
        }
        catch (Exception ex) {
            throw new MailException("Failed to attach the file to this message", ex);
        }
    }

    @Override
    public void addAttachment(File file, String cid) {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.attachFile(file);
            mimeBodyPart.setContentID(cid);
            this.multipart.addBodyPart((BodyPart)mimeBodyPart);
            this.message.setContent(this.multipart);
        }
        catch (Exception ex) {
            throw new MailException("Failed to attach the file to this message", ex);
        }
    }

    @Override
    public void addAttachment(File file, String contentType, String encoding) {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.attachFile(file, contentType, encoding);
            this.multipart.addBodyPart((BodyPart)mimeBodyPart);
            this.message.setContent(this.multipart);
        }
        catch (Exception ex) {
            throw new MailException("Failed to attach the file to this message", ex);
        }
    }

    @Override
    public Instant getSentDate() {
        try {
            return this.message.getSentDate().toInstant();
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to get the sent date from this message", ex);
        }
    }

    @Override
    public void setSentDate(Instant instant) {
        try {
            this.message.setSentDate(Date.from(instant));
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to set the sent date to this message", ex);
        }
    }

    @Override
    public Instant getReceivedDate() {
        try {
            return this.message.getReceivedDate().toInstant();
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to get the received date from this message", ex);
        }
    }

    @Override
    public CompletableFuture<Void> saveChanges() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.message.saveChanges();
            }
            catch (MessagingException ex) {
                throw new MailException("Failed to save changes to this message", ex);
            }
        });
    }

    @Override
    public CompletableFuture<Void> send() {
        return CompletableFuture.runAsync(() -> {
            try {
                Transport.send((Message)this.message);
            }
            catch (MessagingException ex) {
                throw new MailException("Failed to send this message to the specified addresses: " + String.valueOf(this.getAllRecipients()), ex);
            }
        });
    }

    @Override
    public CompletableFuture<Void> send(ImmutableList<String> addresses) {
        return CompletableFuture.supplyAsync(() -> {
            Address[] addressArray = new Address[addresses.size()];
            for (int i = 0; i < addresses.size(); ++i) {
                try {
                    addressArray[i] = new InternetAddress((String)addresses.get(i));
                    continue;
                }
                catch (AddressException ex) {
                    throw new MailException("Failed to parse this mail address: " + (String)addresses.get(i), ex);
                }
            }
            return addressArray;
        }).thenAccept(addressesArray -> {
            try {
                Transport.send((Message)this.message, (Address[])addressesArray);
            }
            catch (MessagingException ex) {
                throw new MailException("Failed to send this message to the specified addresses: " + String.valueOf(addresses), ex);
            }
        });
    }
}

