/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.mail.impl;

import java.util.Properties;
import one.jpro.platform.mail.MailConfig;
import one.jpro.platform.mail.StartTLSOption;
import org.jetbrains.annotations.NotNull;

public class MailConfigImpl
implements MailConfig {
    private final Properties properties = new Properties();

    @Override
    @NotNull
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean isMailDebug() {
        return Boolean.parseBoolean(this.properties.getProperty("mail.debug", String.valueOf(false)));
    }

    @Override
    @NotNull
    public MailConfig setMailDebug(boolean mailDebug) {
        this.properties.put("mail.debug", (Object)mailDebug);
        return this;
    }

    @Override
    @NotNull
    public String getMailSmtpUser() {
        return this.properties.getProperty("mail.smtp.user");
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpUser(String mailSmtpUser) {
        this.properties.put("mail.smtp.user", mailSmtpUser);
        return this;
    }

    @Override
    @NotNull
    public String getMailSmtpHost() {
        return this.properties.getProperty("mail.smtp.host", "");
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpHost(String mailSmtpHost) {
        this.properties.put("mail.smtp.host", mailSmtpHost);
        return this;
    }

    @Override
    public int getMailSmtpPort() {
        return Integer.parseInt(this.properties.getProperty("mail.smtp.port", String.valueOf(25)));
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpPort(int mailSmtpPort) {
        this.properties.put("mail.smtp.port", (Object)mailSmtpPort);
        return this;
    }

    @Override
    public int getMailSmtpConnectionTimeout() {
        return Integer.parseInt(this.properties.getProperty("mail.smtp.connectiontimeout"));
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpConnectionTimeout(int mailSmtpConnectionTimeout) {
        this.properties.put("mail.smtp.connectiontimeout", (Object)mailSmtpConnectionTimeout);
        return this;
    }

    @Override
    public int getMailSmtpTimeout() {
        return Integer.parseInt(this.properties.getProperty("mail.smtp.timeout"));
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpTimeout(int mailSmtpTimeout) {
        this.properties.put("mail.smtp.timeout", (Object)mailSmtpTimeout);
        return this;
    }

    @Override
    public boolean isMailSmtpAuth() {
        return Boolean.parseBoolean(this.properties.getProperty("mail.smtp.auth", String.valueOf(false)));
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpAuth(boolean mailSmtpAuth) {
        this.properties.put("mail.smtp.auth", (Object)mailSmtpAuth);
        return this;
    }

    @Override
    @NotNull
    public String getMailSmtpAuthMechanisms() {
        return this.properties.getProperty("mail.smtp.auth.mechanisms");
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpAuthMechanisms(String mailSmtpAuthMechanisms) {
        this.properties.put("mail.smtp.auth.mechanisms", mailSmtpAuthMechanisms);
        return this;
    }

    @Override
    public boolean isMailSmtpAuthLoginDisable() {
        return Boolean.parseBoolean(this.properties.getProperty("mail.smtp.auth.login.disable"));
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpAuthLoginDisable(boolean mailSmtpAuthLoginDisable) {
        this.properties.put("mail.smtp.auth.login.disable", (Object)mailSmtpAuthLoginDisable);
        return this;
    }

    @Override
    public boolean isMailSmtpAuthPlainDisable() {
        return Boolean.parseBoolean(this.properties.getProperty("mail.smtp.auth.plain.disable"));
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpAuthPlainDisable(boolean mailSmtpAuthPlainDisable) {
        this.properties.put("mail.smtp.auth.plain.disable", (Object)mailSmtpAuthPlainDisable);
        return this;
    }

    @Override
    public boolean isMailSmtpAuthDigestMd5Disable() {
        return Boolean.parseBoolean(this.properties.getProperty("mail.smtp.auth.digest-md5.disable", String.valueOf(false)));
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpAuthDigestMd5Disable(boolean mailSmtpAuthDigestMd5Disable) {
        this.properties.put("mail.smtp.auth.digest-md5.disable", (Object)mailSmtpAuthDigestMd5Disable);
        return this;
    }

    @Override
    public boolean isMailSmtpAuthXOAuth2Disable() {
        return Boolean.parseBoolean(this.properties.getProperty("mail.smtp.auth.xoauth2.disable", String.valueOf(true)));
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpAuthXOAuth2Disable(boolean mailSmtpAuthXOAuth2Disable) {
        this.properties.put("mail.smtp.auth.xoauth2.disable", (Object)mailSmtpAuthXOAuth2Disable);
        return this;
    }

    @Override
    @NotNull
    public StartTLSOption getMailSmtpStartTLS() {
        boolean starttlsEnable = Boolean.parseBoolean(this.properties.getProperty("mail.smtp.starttls.enable", "false"));
        boolean starttlsRequired = Boolean.parseBoolean(this.properties.getProperty("mail.smtp.starttls.required", "false"));
        if (starttlsEnable && starttlsRequired) {
            return StartTLSOption.REQUIRED;
        }
        if (starttlsEnable) {
            return StartTLSOption.ENABLED;
        }
        return StartTLSOption.DISABLED;
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpStartTLS(StartTLSOption mailSmtpStarttls) {
        switch (mailSmtpStarttls) {
            case DISABLED: {
                this.properties.put("mail.smtp.starttls.enable", "false");
                this.properties.put("mail.smtp.starttls.required", "false");
                break;
            }
            case ENABLED: {
                this.properties.put("mail.smtp.starttls.enable", "true");
                this.properties.put("mail.smtp.starttls.required", "false");
                break;
            }
            case REQUIRED: {
                this.properties.put("mail.smtp.starttls.enable", "true");
                this.properties.put("mail.smtp.starttls.required", "true");
            }
        }
        return this;
    }

    @Override
    public boolean isMailSmtpSslEnable() {
        return Boolean.parseBoolean(this.properties.getProperty("mail.smtp.ssl.enable", String.valueOf(false)));
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpSslEnable(boolean mailSmtpSslEnable) {
        this.properties.put("mail.smtp.ssl.enable", (Object)mailSmtpSslEnable);
        return this;
    }

    @Override
    public boolean isMailSmtpSslCheckServerIdentity() {
        return Boolean.parseBoolean(this.properties.getProperty("mail.smtp.ssl.checkserveridentity", String.valueOf(false)));
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpSslCheckServerIdentity(boolean mailSmtpSslCheckServerIdentity) {
        this.properties.put("mail.smtp.ssl.checkserveridentity", (Object)mailSmtpSslCheckServerIdentity);
        return this;
    }

    @Override
    @NotNull
    public String getMailSmtpSslTrust() {
        return this.properties.getProperty("mail.smtp.ssl.trust");
    }

    @Override
    @NotNull
    public MailConfig setMailSmtpSslTrust(String mailSmtpSslTrust) {
        this.properties.put("mail.smtp.ssl.trust", mailSmtpSslTrust);
        return this;
    }
}

