/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.mdfx;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.layout.VBox;
import one.jpro.platform.mdfx.extensions.ImageExtension;
import one.jpro.platform.mdfx.impl.AdaptiveImage;
import one.jpro.platform.mdfx.impl.MDFXNodeHelper;

public class MarkdownView
extends VBox {
    private List<ImageExtension> extensions = new ArrayList<ImageExtension>();
    private final SimpleStringProperty mdString = new SimpleStringProperty("");
    static ImageExtension DEFAULT_IMAGE_EXTENSION = new ImageExtension(null, (url, view) -> {
        if (url.isEmpty()) {
            return new Group();
        }
        Image img = new Image(url, false);
        AdaptiveImage r = new AdaptiveImage(img);
        r.maxWidthProperty().bind((ObservableValue)view.widthProperty());
        return r;
    });

    public MarkdownView(String mdString) {
        this(mdString, MarkdownView.defaultExtensions());
    }

    public MarkdownView(String mdString, List<ImageExtension> extensions) {
        if (extensions.stream().filter(e -> e.getScheme() == null).count() > 1L) {
            throw new IllegalArgumentException("Only one extension can have a scheme of null");
        }
        this.extensions = extensions;
        this.mdString.set(mdString);
        this.mdString.addListener((p, o, n) -> this.updateContent());
        Optional.ofNullable(MarkdownView.class.getResource("/one/jpro/platform/mdfx/mdfx.css")).ifPresent(cssResource -> this.getStylesheets().add((Object)cssResource.toExternalForm()));
        this.getDefaultStylesheets().forEach(arg_0 -> this.getStylesheets().add(arg_0));
        this.updateContent();
    }

    public MarkdownView() {
        this("");
    }

    protected List<String> getDefaultStylesheets() {
        ArrayList<String> defaultStylesheets = new ArrayList<String>();
        Optional.ofNullable(MarkdownView.class.getResource("/one/jpro/platform/mdfx/mdfx-default.css")).ifPresent(cssResource -> defaultStylesheets.add(cssResource.toExternalForm()));
        return defaultStylesheets;
    }

    private void updateContent() {
        MDFXNodeHelper content = new MDFXNodeHelper(this, this.mdString.getValue());
        this.getChildren().clear();
        this.getChildren().add((Object)content);
    }

    public StringProperty mdStringProperty() {
        return this.mdString;
    }

    public void setMdString(String mdString) {
        this.mdString.set(mdString);
    }

    public String getMdString() {
        return this.mdString.get();
    }

    public boolean showChapter(int[] currentChapter) {
        return true;
    }

    public void setLink(Node node, String link, String description) {
    }

    public Node generateImage(String url) {
        Optional<ImageExtension> res = this.extensions.stream().filter(e -> e.getScheme() != null && url.startsWith(e.getScheme())).findFirst();
        if (res.isEmpty()) {
            res = this.extensions.stream().filter(e -> e.getScheme() == null).findFirst();
        }
        return res.get().getFunction().apply(url, this);
    }

    public static List<ImageExtension> defaultExtensions() {
        return new ArrayList<ImageExtension>(List.of(DEFAULT_IMAGE_EXTENSION));
    }
}

