/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.mdfx.impl;

import javafx.geometry.Orientation;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.Pane;

public class AdaptiveImage
extends Pane {
    private final Image img;

    public AdaptiveImage(Image image) {
        this.img = image;
        this.init();
    }

    public AdaptiveImage(String imagePath) {
        this(new Image(imagePath, true));
    }

    private void init() {
        this.setBackground(new Background(new BackgroundImage[]{new BackgroundImage(this.img, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, this.getBackgroundImagePosition())}));
        this.img.widthProperty().addListener((p, o, n) -> this.requestLayout());
        this.img.heightProperty().addListener((p, o, n) -> this.requestLayout());
    }

    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    private double computeHeight(double width) {
        return width * this.img.getHeight() / this.img.getWidth();
    }

    public double computeMinHeight(double width) {
        return width <= 0.0 ? Double.MIN_VALUE : this.computeHeight(width);
    }

    public double computePrefHeight(double width) {
        return width <= 0.0 ? 1.0 : this.computeHeight(width);
    }

    public double computeMaxHeight(double width) {
        return width <= 0.0 ? Double.MAX_VALUE : this.computeHeight(width);
    }

    public double computeMinWidth(double height) {
        return 1.0;
    }

    public double computePrefWidth(double height) {
        return this.img.getWidth();
    }

    public double computeMaxWidth(double height) {
        return this.img.getWidth();
    }

    public double getBaselineOffset() {
        return 30.0;
    }

    private BackgroundSize getBackgroundImagePosition() {
        return new BackgroundSize(1.0, 1.0, true, true, true, false);
    }
}

