/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.recorder;

import java.util.Optional;
import org.json.JSONObject;

public class MediaRecorderException
extends RuntimeException {
    private final String code;

    public MediaRecorderException(String message, Throwable cause) {
        super(message, cause);
        this.code = "0";
    }

    public MediaRecorderException(String code, String message) {
        super(message);
        this.code = code;
    }

    public MediaRecorderException(String code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    public final String getCode() {
        return this.code;
    }

    @Override
    public String toString() {
        StringBuilder errStrBuilder = new StringBuilder(this.getClass().getName() + " [code: " + this.code);
        Optional.ofNullable(this.getMessage()).filter(message -> !message.isBlank()).ifPresent(message -> errStrBuilder.append(", message: ").append((String)message));
        Optional.ofNullable(this.getCause()).ifPresent(cause -> errStrBuilder.append(", cause: ").append(cause));
        return errStrBuilder.append(']').toString();
    }

    public static MediaRecorderException fromJSON(String source) {
        if (source == null || source.length() <= 2) {
            throw new IllegalArgumentException("Source string cannot be null or empty");
        }
        if (source.startsWith("\"") && source.endsWith("\"")) {
            source = source.substring(1, source.length() - 1).replace("\\", "");
        }
        JSONObject json = new JSONObject(source);
        String code = json.getString("code");
        String message = json.getString("message");
        return new MediaRecorderException(code, message);
    }
}

