/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.recorder.impl;

import com.sun.javafx.event.EventHandlerManager;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.util.Duration;
import one.jpro.platform.media.MediaSource;
import one.jpro.platform.media.event.MediaRecorderEvent;
import one.jpro.platform.media.recorder.MediaRecorder;
import one.jpro.platform.media.recorder.MediaRecorderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseMediaRecorder
implements MediaRecorder {
    private RecorderTimerTask recorderTimerTask;
    volatile boolean recorderReady;
    volatile boolean isUpdateDurationEnabled;
    long startRecordingTime = 0L;
    private double pauseDurationTime = 0.0;
    private final Logger log = LoggerFactory.getLogger(BaseMediaRecorder.class);
    ReadOnlyObjectWrapper<MediaSource> mediaSource;
    private ReadOnlyObjectWrapper<MediaRecorder.Status> status;
    private ReadOnlyObjectWrapper<Duration> duration;
    private ObjectProperty<EventHandler<MediaRecorderEvent>> onReady;
    private ObjectProperty<EventHandler<MediaRecorderEvent>> onDataAvailable;
    private ObjectProperty<EventHandler<MediaRecorderEvent>> onStart;
    private ObjectProperty<EventHandler<MediaRecorderEvent>> onPaused;
    private ObjectProperty<EventHandler<MediaRecorderEvent>> onResume;
    private ObjectProperty<EventHandler<MediaRecorderEvent>> onStopped;
    private ObjectProperty<EventHandler<MediaRecorderEvent>> onError;
    private ReadOnlyObjectWrapper<MediaRecorderException> error;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);

    BaseMediaRecorder() {
    }

    @Override
    public final MediaSource getMediaSource() {
        return this.mediaSource == null ? null : (MediaSource)this.mediaSource.get();
    }

    final void setMediaSource(MediaSource value) {
        this.mediaResourcePropertyImpl().set((Object)value);
    }

    @Override
    public final ReadOnlyObjectProperty<MediaSource> mediaSourceProperty() {
        return this.mediaResourcePropertyImpl().getReadOnlyProperty();
    }

    ReadOnlyObjectWrapper<MediaSource> mediaResourcePropertyImpl() {
        if (this.mediaSource == null) {
            this.mediaSource = new ReadOnlyObjectWrapper((Object)this, "mediaSource");
        }
        return this.mediaSource;
    }

    @Override
    public final MediaRecorder.Status getStatus() {
        return this.status == null ? MediaRecorder.Status.INACTIVE : (MediaRecorder.Status)((Object)this.status.get());
    }

    final void setStatus(MediaRecorder.Status value) {
        this.statusPropertyImpl().set((Object)value);
    }

    @Override
    public final ReadOnlyObjectProperty<MediaRecorder.Status> statusProperty() {
        return this.statusPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<MediaRecorder.Status> statusPropertyImpl() {
        if (this.status == null) {
            this.status = new ReadOnlyObjectWrapper<MediaRecorder.Status>((Object)this, "status", MediaRecorder.Status.INACTIVE){

                protected void invalidated() {
                    switch ((MediaRecorder.Status)((Object)this.get())) {
                        case READY: {
                            BaseMediaRecorder.this.startRecordingTime = 0L;
                            BaseMediaRecorder.this.pauseDurationTime = 0.0;
                            break;
                        }
                        case RECORDING: {
                            BaseMediaRecorder.this.startRecordingTime = 0L;
                            BaseMediaRecorder.this.createRecorderTimer();
                            break;
                        }
                        case PAUSED: {
                            BaseMediaRecorder.this.isUpdateDurationEnabled = false;
                            BaseMediaRecorder.this.pauseDurationTime += (double)(System.currentTimeMillis() - BaseMediaRecorder.this.startRecordingTime);
                            break;
                        }
                        case INACTIVE: {
                            BaseMediaRecorder.this.startRecordingTime = 0L;
                            BaseMediaRecorder.this.pauseDurationTime = 0.0;
                            BaseMediaRecorder.this.destroyerRecorderTimer();
                        }
                    }
                }
            };
        }
        return this.status;
    }

    @Override
    public Duration getDuration() {
        return this.duration == null ? Duration.ZERO : (Duration)this.duration.get();
    }

    void setDuration(Duration value) {
        this.durationPropertyImpl().set((Object)value);
    }

    @Override
    public ReadOnlyObjectProperty<Duration> durationProperty() {
        return this.durationPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Duration> durationPropertyImpl() {
        if (this.duration == null) {
            this.duration = new ReadOnlyObjectWrapper<Duration>((Object)this, "duration", Duration.ZERO){

                protected void invalidated() {
                    BaseMediaRecorder.this.log.trace("Recording duration: {} s", (Object)((Duration)this.get()).toSeconds());
                }
            };
        }
        return this.duration;
    }

    @Override
    public final EventHandler<MediaRecorderEvent> getOnReady() {
        return this.onReady == null ? null : (EventHandler)this.onReady.get();
    }

    @Override
    public final void setOnReady(EventHandler<MediaRecorderEvent> value) {
        this.onReadyProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaRecorderEvent>> onReadyProperty() {
        if (this.onReady == null) {
            this.onReady = new SimpleObjectProperty<EventHandler<MediaRecorderEvent>>((Object)this, "onReady"){

                protected void invalidated() {
                    BaseMediaRecorder.this.eventHandlerManager.setEventHandler(MediaRecorderEvent.MEDIA_RECORDER_READY, (EventHandler)this.get());
                }
            };
        }
        return this.onReady;
    }

    @Override
    public final EventHandler<MediaRecorderEvent> getOnDataAvailable() {
        return this.onDataAvailable == null ? null : (EventHandler)this.onDataAvailable.get();
    }

    @Override
    public final void setOnDataAvailable(EventHandler<MediaRecorderEvent> value) {
        this.onDataAvailableProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaRecorderEvent>> onDataAvailableProperty() {
        if (this.onDataAvailable == null) {
            this.onDataAvailable = new SimpleObjectProperty<EventHandler<MediaRecorderEvent>>((Object)this, "onDataAvailable"){

                protected void invalidated() {
                    BaseMediaRecorder.this.eventHandlerManager.setEventHandler(MediaRecorderEvent.MEDIA_RECORDER_DATA_AVAILABLE, (EventHandler)this.get());
                }
            };
        }
        return this.onDataAvailable;
    }

    @Override
    public final EventHandler<MediaRecorderEvent> getOnStart() {
        return this.onStart == null ? null : (EventHandler)this.onStart.get();
    }

    @Override
    public final void setOnStart(EventHandler<MediaRecorderEvent> value) {
        this.onStartProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaRecorderEvent>> onStartProperty() {
        if (this.onStart == null) {
            this.onStart = new SimpleObjectProperty<EventHandler<MediaRecorderEvent>>((Object)this, "onStart"){

                protected void invalidated() {
                    BaseMediaRecorder.this.eventHandlerManager.setEventHandler(MediaRecorderEvent.MEDIA_RECORDER_START, (EventHandler)this.get());
                }
            };
        }
        return this.onStart;
    }

    @Override
    public final EventHandler<MediaRecorderEvent> getOnPaused() {
        return this.onPaused == null ? null : (EventHandler)this.onPaused.get();
    }

    @Override
    public final void setOnPaused(EventHandler<MediaRecorderEvent> value) {
        this.onPausedProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaRecorderEvent>> onPausedProperty() {
        if (this.onPaused == null) {
            this.onPaused = new SimpleObjectProperty<EventHandler<MediaRecorderEvent>>((Object)this, "onPaused"){

                protected void invalidated() {
                    BaseMediaRecorder.this.eventHandlerManager.setEventHandler(MediaRecorderEvent.MEDIA_RECORDER_PAUSE, (EventHandler)this.get());
                }
            };
        }
        return this.onPaused;
    }

    @Override
    public final EventHandler<MediaRecorderEvent> getOnResume() {
        return this.onResume == null ? null : (EventHandler)this.onResume.get();
    }

    @Override
    public final void setOnResume(EventHandler<MediaRecorderEvent> value) {
        this.onResumeProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaRecorderEvent>> onResumeProperty() {
        if (this.onResume == null) {
            this.onResume = new SimpleObjectProperty<EventHandler<MediaRecorderEvent>>((Object)this, "onResume"){

                protected void invalidated() {
                    BaseMediaRecorder.this.eventHandlerManager.setEventHandler(MediaRecorderEvent.MEDIA_RECORDER_RESUME, (EventHandler)this.get());
                }
            };
        }
        return this.onResume;
    }

    @Override
    public final EventHandler<MediaRecorderEvent> getOnStopped() {
        return this.onStopped == null ? null : (EventHandler)this.onStopped.get();
    }

    @Override
    public final void setOnStopped(EventHandler<MediaRecorderEvent> value) {
        this.onStoppedProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaRecorderEvent>> onStoppedProperty() {
        if (this.onStopped == null) {
            this.onStopped = new SimpleObjectProperty<EventHandler<MediaRecorderEvent>>((Object)this, "onStopped"){

                protected void invalidated() {
                    BaseMediaRecorder.this.eventHandlerManager.setEventHandler(MediaRecorderEvent.MEDIA_RECORDER_STOP, (EventHandler)this.get());
                }
            };
        }
        return this.onStopped;
    }

    @Override
    public final EventHandler<MediaRecorderEvent> getOnError() {
        return this.onError == null ? null : (EventHandler)this.onError.get();
    }

    @Override
    public final void setOnError(EventHandler<MediaRecorderEvent> value) {
        this.onErrorProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaRecorderEvent>> onErrorProperty() {
        if (this.onError == null) {
            this.onError = new SimpleObjectProperty<EventHandler<MediaRecorderEvent>>((Object)this, "onError"){

                protected void invalidated() {
                    BaseMediaRecorder.this.eventHandlerManager.setEventHandler(MediaRecorderEvent.MEDIA_RECORDER_ERROR, (EventHandler)this.get());
                }
            };
        }
        return this.onError;
    }

    @Override
    public final MediaRecorderException getError() {
        return this.error == null ? null : (MediaRecorderException)this.error.get();
    }

    final void setError(MediaRecorderException error) {
        this.errorPropertyImpl().set((Object)error);
    }

    @Override
    public final ReadOnlyObjectProperty<MediaRecorderException> errorProperty() {
        return this.errorPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<MediaRecorderException> errorPropertyImpl() {
        if (this.error == null) {
            this.error = new ReadOnlyObjectWrapper<MediaRecorderException>((Object)this, "error"){

                protected void invalidated() {
                    MediaRecorderException exception = (MediaRecorderException)this.get();
                    if (exception != null) {
                        Event.fireEvent((EventTarget)BaseMediaRecorder.this, (Event)new MediaRecorderEvent(BaseMediaRecorder.this, MediaRecorderEvent.MEDIA_RECORDER_ERROR));
                    }
                }
            };
        }
        return this.error;
    }

    public final EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return tail.prepend((EventDispatcher)this.eventHandlerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createRecorderTimer() {
        Object object = RecorderTimerTask.timerLock;
        synchronized (object) {
            if (this.recorderTimerTask == null) {
                this.recorderTimerTask = new RecorderTimerTask(this);
                this.recorderTimerTask.start();
            }
            this.isUpdateDurationEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyerRecorderTimer() {
        Object object = RecorderTimerTask.timerLock;
        synchronized (object) {
            if (this.recorderTimerTask != null) {
                this.isUpdateDurationEnabled = false;
                this.recorderTimerTask.stop();
                this.recorderTimerTask = null;
            }
        }
    }

    void updateDuration() {
        if (this.recorderReady && this.isUpdateDurationEnabled) {
            long recordingTime;
            if (this.startRecordingTime == 0L) {
                this.startRecordingTime = System.currentTimeMillis();
            }
            if ((recordingTime = System.currentTimeMillis() - this.startRecordingTime) >= 0L) {
                this.setDuration(Duration.millis((double)(this.pauseDurationTime + (double)recordingTime)));
            }
        }
    }

    static class RecorderTimerTask
    extends TimerTask {
        static final Object timerLock = new Object();
        private Timer recoderTimer;
        private final WeakReference<BaseMediaRecorder> recorderRef;

        RecorderTimerTask(BaseMediaRecorder recorder) {
            this.recorderRef = new WeakReference<BaseMediaRecorder>(recorder);
        }

        void start() {
            if (this.recoderTimer == null) {
                this.recoderTimer = new Timer("RecorderTimerTask", true);
                this.recoderTimer.scheduleAtFixedRate((TimerTask)this, 0L, 100L);
            }
        }

        void stop() {
            if (this.recoderTimer != null) {
                this.recoderTimer.cancel();
                this.recoderTimer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = timerLock;
            synchronized (object) {
                BaseMediaRecorder recorder = (BaseMediaRecorder)this.recorderRef.get();
                if (recorder != null) {
                    Platform.runLater(() -> {
                        Object object = timerLock;
                        synchronized (object) {
                            recorder.updateDuration();
                        }
                    });
                } else {
                    this.cancel();
                }
            }
        }
    }
}

