/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media;

import com.jpro.webapi.WebAPI;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.NamedArg;

public record MediaSource(String source, boolean isLocal, WebAPI.JSFile jsFile) {
    public MediaSource {
        Objects.requireNonNull(source, "Source can not be null");
        if (isLocal) {
            try {
                new URI(source);
            }
            catch (URISyntaxException use) {
                throw new IllegalArgumentException(use);
            }
        }
    }

    public MediaSource(@NamedArg(value="source") String source) {
        this(source, true, null);
    }

    public MediaSource(WebAPI.JSFile jsFile) {
        this(jsFile.getObjectURL().getName(), false, jsFile);
    }

    public MediaSource(File file) {
        this(file.toURI().toString());
    }

    public Optional<File> file() {
        if (this.isLocal) {
            return Optional.of(new File(URI.create(this.source)));
        }
        return Optional.empty();
    }
}

