/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.player.impl;

import java.util.Arrays;
import java.util.Optional;

public enum WebMediaError {
    MEDIA_ERR_ABORTED(0, "fetching process aborted by user"),
    MEDIA_ERR_NETWORK(1, "error occurred when downloading"),
    MEDIA_ERR_DECODE(2, "error occurred when decoding"),
    MEDIA_ERR_SRC_NOT_SUPPORTED(3, "audio/video not supported");

    private final int code;
    private final String description;

    private WebMediaError(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static Optional<WebMediaError> fromCode(int code) {
        return Arrays.stream(WebMediaError.values()).filter(error -> error.getCode() == code).findFirst();
    }
}

