/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.recorder.impl;

import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ShortBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import one.jpro.platform.media.MediaSource;
import one.jpro.platform.media.event.MediaRecorderEvent;
import one.jpro.platform.media.recorder.MediaRecorder;
import one.jpro.platform.media.recorder.MediaRecorderException;
import one.jpro.platform.media.recorder.impl.BaseMediaRecorder;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.FrameRecorder;
import org.bytedeco.javacv.JavaFXFrameConverter;
import org.bytedeco.javacv.OpenCVFrameGrabber;
import org.bytedeco.javacv.VideoInputFrameGrabber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FXMediaRecorder
extends BaseMediaRecorder {
    private final Logger log = LoggerFactory.getLogger(FXMediaRecorder.class);
    private static final Path RECORDING_PATH = Path.of(System.getProperty("user.home"), ".jpro", "video", "capture");
    private static final String DIVIDER_LINE = CharBuffer.allocate(80).toString().replace('\u0000', '*');
    private static final int WEBCAM_DEVICE_INDEX = 0;
    private static final int FRAME_RATE = 30;
    private static final String MP4_FILE_EXTENSION = ".mp4";
    private final FrameGrabber webcamGrabber;
    private final JavaFXFrameConverter frameConverter;
    private final ImageView frameView;
    private double frameRate;
    private static final int DEFAULT_AUDIO_SAMPLE_RATE = 44100;
    private static final int DEFAULT_AUDIO_CHANNELS = 0;
    private static final int DEFAULT_AUDIO_FRAME_SIZE = 1;
    private AudioFormat audioFormat;
    private TargetDataLine micLine;
    private int audioSampleRate;
    private int audioNumChannels;
    private FFmpegFrameRecorder recorder;
    private Path tempVideoFile;
    private volatile boolean recordingStarted = false;
    private volatile boolean recordingStopped = false;
    private final ThreadGroup scheduledThreadGroup = new ThreadGroup("Media Recorder thread pool");
    private int threadCounter;
    private final ExecutorService videoExecutorService;
    private final ScheduledExecutorService audioExecutorService;
    private final ExecutorService startStopRecordingExecutorService;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    public FXMediaRecorder() {
        avutil.av_log_set_level((int)16);
        ThreadFactory threadFactory = run -> {
            Thread thread = new Thread(this.scheduledThreadGroup, run);
            thread.setName("Media Recorder Thread " + this.threadCounter++);
            thread.setPriority(1);
            thread.setDaemon(true);
            return thread;
        };
        this.videoExecutorService = Executors.newSingleThreadExecutor(threadFactory);
        this.audioExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.startStopRecordingExecutorService = Executors.newSingleThreadExecutor(threadFactory);
        this.webcamGrabber = this.isOsWindows() ? new VideoInputFrameGrabber(0) : new OpenCVFrameGrabber(0);
        this.frameConverter = new JavaFXFrameConverter();
        this.frameView = new ImageView();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.stopRecording();
            this.release();
            if (Files.exists(RECORDING_PATH, new LinkOption[0])) {
                try (Stream<Path> pathStream = Files.walk(RECORDING_PATH, new FileVisitOption[0]);){
                    pathStream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (IOException ex) {
                    this.log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }));
    }

    ImageView getCameraView() {
        return this.frameView;
    }

    @Override
    public void enable() {
        if (this.recorderReady) {
            this.log.info("Media recorder is already enabled.");
        } else {
            this.log.debug("Enabling media recorder...");
            Runnable frameGrabber = () -> {
                block10: {
                    try {
                        this.webcamGrabber.start();
                        this.frameRate = this.webcamGrabber.getFrameRate() < 30.0 ? 30.0 : this.webcamGrabber.getFrameRate();
                        this.printCaptureDeviceDescription();
                    }
                    catch (FrameGrabber.Exception ex) {
                        this.setError("Exception during the enabling of video camera stream.", (Exception)((Object)ex));
                        this.release();
                    }
                    try {
                        this.enableAudioCapture();
                    }
                    catch (LineUnavailableException ex) {
                        this.setError("Exception on creating audio input line from the microphone.", ex);
                        if (this.micLine == null) break block10;
                        this.micLine.close();
                    }
                }
                this.recorderReady = true;
                Platform.runLater(() -> {
                    this.setStatus(MediaRecorder.Status.READY);
                    Event.fireEvent((EventTarget)this, (Event)new MediaRecorderEvent(this, MediaRecorderEvent.MEDIA_RECORDER_READY));
                });
                try {
                    while (this.recorderReady) {
                        Frame frame;
                        this.readLock.lock();
                        try {
                            frame = this.webcamGrabber.grab();
                        }
                        finally {
                            this.readLock.unlock();
                        }
                        if (frame == null) continue;
                        this.updateCameraView(this.frameView, this.frameConverter.convert(frame));
                        this.writeVideoFrame(frame);
                    }
                }
                catch (FrameGrabber.Exception ex) {
                    this.setError("Exception during camera stream frame grabbing.", (Exception)((Object)ex));
                    this.release();
                }
            };
            this.videoExecutorService.execute(frameGrabber);
        }
    }

    private void writeVideoFrame(Frame frame) {
        if (!this.recordingStopped && this.recorder != null) {
            this.writeLock.lock();
            try {
                this.recorder.record(frame);
            }
            catch (FFmpegFrameRecorder.Exception ex) {
                this.setError("Exception during video frame recording.", (Exception)((Object)ex));
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private void enableAudioCapture() throws LineUnavailableException {
        Mixer.Info micDevice = this.getDefaultMicDevice();
        if (micDevice != null) {
            Mixer micMixer = AudioSystem.getMixer(micDevice);
            this.audioFormat = new AudioFormat(44100.0f, 16, 1, true, false);
            DataLine.Info dataLineInfo = new DataLine.Info(TargetDataLine.class, this.audioFormat);
            if (micMixer.isLineSupported(dataLineInfo)) {
                this.micLine = (TargetDataLine)micMixer.getLine(dataLineInfo);
                this.micLine.open(this.audioFormat);
                this.micLine.start();
                this.audioSampleRate = (int)this.audioFormat.getSampleRate();
                this.audioNumChannels = this.audioFormat.getChannels();
            }
            Runnable audioSampleGrabber = () -> {
                if (this.recordingStarted) {
                    int audioBufferSize = this.audioSampleRate * this.audioNumChannels;
                    byte[] audioBytes = new byte[audioBufferSize];
                    int nBytesRead = 0;
                    while (nBytesRead == 0) {
                        nBytesRead = this.micLine.read(audioBytes, 0, this.micLine.available());
                    }
                    int nSamplesRead = nBytesRead / 2;
                    short[] samples = new short[nSamplesRead];
                    ByteOrder byteOrder = this.audioFormat.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
                    ByteBuffer.wrap(audioBytes).order(byteOrder).asShortBuffer().get(samples);
                    ShortBuffer samplesBuff = ShortBuffer.wrap(samples, 0, nSamplesRead);
                    if (!this.recordingStopped && this.recorder != null) {
                        this.writeLock.lock();
                        try {
                            this.recorder.recordSamples(this.audioSampleRate, this.audioNumChannels, new Buffer[]{samplesBuff});
                        }
                        catch (FFmpegFrameRecorder.Exception ex) {
                            this.setError("Exception on recording the audio samples.", (Exception)((Object)ex));
                        }
                        finally {
                            this.writeLock.unlock();
                        }
                    }
                }
            };
            long period = (long)(1000.0 / this.frameRate);
            this.audioExecutorService.scheduleAtFixedRate(audioSampleGrabber, 0L, period, TimeUnit.MILLISECONDS);
        }
    }

    private Mixer.Info getDefaultMicDevice() {
        Mixer.Info[] mixerInfos;
        for (Mixer.Info info : mixerInfos = AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(info);
            Line.Info[] lineInfos = mixer.getTargetLineInfo();
            if (lineInfos.length < 1 || !lineInfos[0].getLineClass().equals(TargetDataLine.class)) continue;
            this.log.debug(DIVIDER_LINE);
            for (Line.Info lineInfo : lineInfos) {
                this.log.debug("Mic Line Name: " + info.getName());
                this.log.debug("Mic Line Description: " + info.getDescription());
                this.printSupportedAudioFormats(lineInfo);
            }
            this.log.debug(DIVIDER_LINE);
            return info;
        }
        return null;
    }

    @Override
    public void start() {
        if (this.getStatus().equals((Object)MediaRecorder.Status.INACTIVE) || this.getStatus().equals((Object)MediaRecorder.Status.READY)) {
            Runnable startRecordingRunnable = () -> {
                if (this.recorderReady) {
                    this.tempVideoFile = this.createTempFilename("video_", MP4_FILE_EXTENSION);
                    this.recorder = new FFmpegFrameRecorder(this.tempVideoFile.toString(), this.webcamGrabber.getImageWidth(), this.webcamGrabber.getImageHeight());
                    this.recorder.setInterleaved(true);
                    this.recorder.setVideoOption("tune", "zerolatency");
                    this.recorder.setVideoOption("preset", "ultrafast");
                    this.recorder.setVideoOption("crf", "28");
                    this.recorder.setVideoBitrate(0x800000);
                    this.recorder.setVideoCodec(27);
                    this.recorder.setFormat("mp4");
                    this.recorder.setFrameRate(this.frameRate);
                    this.recorder.setGopSize((int)(this.frameRate * 2.0));
                    this.recorder.setAudioOption("crf", "0");
                    this.recorder.setAudioQuality(0.0);
                    this.recorder.setAudioBitrate(192000);
                    this.recorder.setAudioCodec(86018);
                    this.recorder.setSampleRate(this.getAudioSampleRate());
                    this.recorder.setAudioChannels(this.getAudioChannels());
                    try {
                        this.recorder.start();
                        this.recordingStopped = false;
                        this.recordingStarted = true;
                        Platform.runLater(() -> {
                            this.setStatus(MediaRecorder.Status.RECORDING);
                            Event.fireEvent((EventTarget)this, (Event)new MediaRecorderEvent(this, MediaRecorderEvent.MEDIA_RECORDER_START));
                        });
                    }
                    catch (FFmpegFrameRecorder.Exception ex) {
                        this.setError("Exception on starting the audio/video recorder.", (Exception)((Object)ex));
                    }
                } else {
                    this.log.info("Please, enable the camera first!");
                }
            };
            this.startStopRecordingExecutorService.execute(startRecordingRunnable);
        } else if (this.getStatus().equals((Object)MediaRecorder.Status.PAUSED) && this.recorderReady) {
            this.recordingStarted = true;
            this.setStatus(MediaRecorder.Status.RECORDING);
            Event.fireEvent((EventTarget)this, (Event)new MediaRecorderEvent(this, MediaRecorderEvent.MEDIA_RECORDER_RESUME));
        }
    }

    @Override
    public void pause() {
        this.recordingStarted = false;
        this.setStatus(MediaRecorder.Status.PAUSED);
        Event.fireEvent((EventTarget)this, (Event)new MediaRecorderEvent(this, MediaRecorderEvent.MEDIA_RECORDER_PAUSE));
    }

    @Override
    public void stop() {
        Runnable startRecordingRunnable = () -> {
            this.stopRecording();
            Platform.runLater(() -> {
                this.setMediaSource(new MediaSource(this.tempVideoFile.toUri().toString()));
                this.setStatus(MediaRecorder.Status.INACTIVE);
                Event.fireEvent((EventTarget)this, (Event)new MediaRecorderEvent(this, MediaRecorderEvent.MEDIA_RECORDER_STOP));
            });
        };
        this.startStopRecordingExecutorService.execute(startRecordingRunnable);
    }

    private void stopRecording() {
        this.recordingStarted = false;
        this.recordingStopped = true;
        if (this.recorder != null) {
            this.writeLock.lock();
            try {
                this.recorder.close();
            }
            catch (FrameRecorder.Exception ex) {
                this.setError("Exception on stopping the audio/video recorder", (Exception)((Object)ex));
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public void release() {
        this.recorderReady = false;
        this.releaseVideoResources();
        this.releaseAudioResources();
    }

    private void releaseVideoResources() {
        if (this.videoExecutorService != null && !this.videoExecutorService.isShutdown()) {
            try {
                if (this.webcamGrabber != null) {
                    this.webcamGrabber.release();
                }
                this.videoExecutorService.shutdown();
                this.videoExecutorService.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | FrameGrabber.Exception ex) {
                this.setError("Exception in stopping the video frame capture service.", (Exception)ex);
            }
        }
    }

    private void releaseAudioResources() {
        if (this.audioExecutorService != null && !this.audioExecutorService.isShutdown()) {
            try {
                if (this.micLine != null) {
                    this.micLine.close();
                }
                this.audioExecutorService.shutdown();
                this.audioExecutorService.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                this.setError("Exception in stopping the audio frame capture service.", ex);
            }
        }
    }

    private int getAudioSampleRate() {
        if (this.audioFormat == null) {
            return 44100;
        }
        int sampleRate = (int)this.audioFormat.getSampleRate();
        return sampleRate == -1 ? 44100 : sampleRate;
    }

    private int getAudioChannels() {
        if (this.audioFormat == null) {
            return 0;
        }
        int audioChannels = this.audioFormat.getChannels();
        return audioChannels == -1 ? 0 : audioChannels;
    }

    private int getFrameSize() {
        if (this.audioFormat == null) {
            return 1;
        }
        int frameSize = this.audioFormat.getFrameSize();
        return frameSize == -1 ? 1 : frameSize;
    }

    private void updateCameraView(ImageView view, Image image) {
        Platform.runLater(() -> view.setImage(image));
    }

    private Path createTempFilename(String prefix, String postfix) {
        Path tempFile;
        Path parentDir;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String filename = "vid_" + random.nextInt(0, Integer.MAX_VALUE);
        if (prefix != null) {
            filename = prefix + random.nextInt(0, Integer.MAX_VALUE);
        }
        if (postfix != null) {
            filename = filename + postfix;
        }
        if (Files.notExists(parentDir = (tempFile = RECORDING_PATH.resolve(filename)).getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            catch (IOException ex) {
                this.log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return tempFile;
    }

    private boolean isOsWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private void setError(String message, Exception ex) {
        if (Platform.isFxApplicationThread()) {
            this.setError(new MediaRecorderException(message, ex));
        } else {
            Platform.runLater(() -> this.setError(new MediaRecorderException(message, ex)));
        }
        this.log.error(message, (Throwable)ex);
    }

    private void printCaptureDeviceDescription() {
        this.log.debug(DIVIDER_LINE);
        if (this.isOsWindows()) {
            try {
                this.log.debug("Capture devices: " + Arrays.toString(VideoInputFrameGrabber.getDeviceDescriptions()));
            }
            catch (FrameGrabber.Exception ex) {
                this.log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        this.log.debug("Capture Device Info:");
        this.log.debug("Image Width: " + this.webcamGrabber.getImageWidth());
        this.log.debug("Image Height: " + this.webcamGrabber.getImageHeight());
        this.log.debug("Frame Rate: " + this.frameRate);
    }

    private void printSupportedAudioFormats(Line.Info lineInfo) {
        if (lineInfo instanceof DataLine.Info) {
            DataLine.Info dataLineInfo = (DataLine.Info)lineInfo;
            this.log.debug("Supported Audio Formats:");
            Arrays.stream(dataLineInfo.getFormats()).forEach(format -> this.log.debug("{}", format));
        }
    }
}

