/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.util;

import com.jpro.webapi.WebAPI;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import one.jpro.platform.media.MediaSource;

public final class MediaUtil {
    public static Optional<MediaSource> retrieve(Stage stage, MediaSource mediaSource, String fileName) throws IOException {
        if (WebAPI.isBrowser()) {
            WebAPI webAPI = WebAPI.getWebAPI((Window)stage);
            if (!mediaSource.isLocal()) {
                WebAPI.JSFile jsFile = mediaSource.jsFile();
                if (jsFile != null) {
                    webAPI.executeScript("let download_link = document.createElement(\"a\");\ndownload_link.setAttribute(\"download\", \"$fileName.webm\");\ndownload_link.href = %s;\ndownload_link.click();\n".formatted(jsFile.getObjectURL().getName()).replace("$fileName.webm", fileName));
                }
                return Optional.of(mediaSource);
            }
        } else {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Save media file...");
            Optional<File> optionalFile = mediaSource.file();
            if (optionalFile.isPresent()) {
                File mediaFile = optionalFile.get();
                String initialFileName = MediaUtil.getExtension(mediaFile.getName()).map(ext -> fileName + "." + ext).orElseGet(() -> mediaFile.toPath().getFileName().toString());
                fileChooser.setInitialFileName(initialFileName);
                File saveToFile = fileChooser.showSaveDialog((Window)stage);
                if (saveToFile != null) {
                    Files.copy(mediaFile.toPath(), saveToFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    return Optional.of(new MediaSource(saveToFile.toURI().toString()));
                }
                return Optional.of(mediaSource);
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getExtension(String fileName) {
        return Optional.ofNullable(fileName).filter(f -> f.contains(".")).map(f -> f.substring(fileName.lastIndexOf(".") + 1));
    }

    private MediaUtil() {
    }
}

