/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.player.impl;

import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import one.jpro.platform.media.MediaEngine;
import one.jpro.platform.media.MediaView;
import one.jpro.platform.media.player.impl.FXMediaPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXMediaPlayerView
extends MediaView {
    private final Logger log = LoggerFactory.getLogger(FXMediaPlayerView.class);
    private javafx.scene.media.MediaView fxMediaView;
    private final InvalidationListener updateViewContainerListener = observable -> this.updateViewContainer();
    private final WeakInvalidationListener weakUpdateViewContainerListener = new WeakInvalidationListener(this.updateViewContainerListener);

    public FXMediaPlayerView() {
        this.getStyleClass().add((Object)"media-view");
    }

    public FXMediaPlayerView(FXMediaPlayer mediaPlayer) {
        this();
        this.setMediaEngine(mediaPlayer);
    }

    @Override
    public ObjectProperty<MediaEngine> mediaEngineProperty() {
        if (this.mediaEngine == null) {
            this.mediaEngine = new SimpleObjectProperty<MediaEngine>((Object)this, "mediaEngine"){

                protected void invalidated() {
                    FXMediaPlayerView.this.sceneProperty().removeListener((InvalidationListener)FXMediaPlayerView.this.weakUpdateViewContainerListener);
                    FXMediaPlayerView.this.updateViewContainer();
                    FXMediaPlayerView.this.sceneProperty().addListener((InvalidationListener)FXMediaPlayerView.this.weakUpdateViewContainerListener);
                }
            };
        }
        return this.mediaEngine;
    }

    @Override
    public final DoubleProperty fitWidthProperty() {
        if (this.fitWidth == null) {
            this.fitWidth = new SimpleDoubleProperty((Object)this, "fitWidth"){

                protected void invalidated() {
                    FXMediaPlayerView.this.setInternalFitWidth(this.get());
                }
            };
        }
        return this.fitWidth;
    }

    @Override
    public DoubleProperty fitHeightProperty() {
        if (this.fitHeight == null) {
            this.fitHeight = new SimpleDoubleProperty((Object)this, "fitHeight"){

                protected void invalidated() {
                    FXMediaPlayerView.this.setInternalFitHeight(this.get());
                }
            };
        }
        return this.fitHeight;
    }

    @Override
    public final BooleanProperty preserveRatioProperty() {
        if (this.preserveRatio == null) {
            this.preserveRatio = new SimpleBooleanProperty((Object)this, "preserveRatio", true){

                protected void invalidated() {
                    if (FXMediaPlayerView.this.fxMediaView != null) {
                        FXMediaPlayerView.this.fxMediaView.setPreserveRatio(this.get());
                    }
                }
            };
        }
        return this.preserveRatio;
    }

    private void setInternalFitWidth(double fitWidth) {
        if (this.fxMediaView != null) {
            if (fitWidth == 0.0) {
                this.getChildren().remove((Object)this.fxMediaView);
            } else if (!this.getChildren().contains((Object)this.fxMediaView)) {
                this.getChildren().add((Object)this.fxMediaView);
            }
            this.fxMediaView.setFitWidth(fitWidth);
            this.log.trace("video width: {}", (Object)fitWidth);
        }
    }

    private void setInternalFitHeight(double fitHeight) {
        if (this.fxMediaView != null) {
            if (fitHeight == 0.0) {
                this.getChildren().remove((Object)this.fxMediaView);
            } else if (!this.getChildren().contains((Object)this.fxMediaView)) {
                this.getChildren().add((Object)this.fxMediaView);
            }
            this.fxMediaView.setFitHeight(fitHeight);
            this.log.trace("video height: " + fitHeight);
        }
    }

    private void updateViewContainer() {
        MediaEngine mediaEngine;
        if (this.getScene() != null && (mediaEngine = this.getMediaEngine()) instanceof FXMediaPlayer) {
            FXMediaPlayer fxMediaPlayer = (FXMediaPlayer)mediaEngine;
            this.fxMediaView = new javafx.scene.media.MediaView(fxMediaPlayer.getMediaPlayer());
            this.fxMediaView.setPreserveRatio(this.isPreserveRatio());
            this.setInternalFitWidth(this.getFitWidth());
            this.setInternalFitHeight(this.getFitHeight());
        }
    }
}

