/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.recorder;

import com.jpro.webapi.WebAPI;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import one.jpro.platform.media.MediaEngine;
import one.jpro.platform.media.MediaSource;
import one.jpro.platform.media.event.MediaRecorderEvent;
import one.jpro.platform.media.recorder.MediaRecorderException;
import one.jpro.platform.media.recorder.impl.FXMediaRecorder;
import one.jpro.platform.media.recorder.impl.WebMediaRecorder;

public interface MediaRecorder
extends MediaEngine,
EventTarget {
    public static MediaRecorder create(Stage stage) {
        if (WebAPI.isBrowser()) {
            WebAPI webAPI = WebAPI.getWebAPI((Window)stage);
            return new WebMediaRecorder(webAPI);
        }
        return new FXMediaRecorder();
    }

    public MediaSource getMediaSource();

    public ReadOnlyObjectProperty<MediaSource> mediaSourceProperty();

    public Status getStatus();

    public ReadOnlyObjectProperty<Status> statusProperty();

    public Duration getDuration();

    public ReadOnlyObjectProperty<Duration> durationProperty();

    public EventHandler<MediaRecorderEvent> getOnReady();

    public void setOnReady(EventHandler<MediaRecorderEvent> var1);

    public ObjectProperty<EventHandler<MediaRecorderEvent>> onReadyProperty();

    public EventHandler<MediaRecorderEvent> getOnDataAvailable();

    public void setOnDataAvailable(EventHandler<MediaRecorderEvent> var1);

    public ObjectProperty<EventHandler<MediaRecorderEvent>> onDataAvailableProperty();

    public EventHandler<MediaRecorderEvent> getOnStart();

    public void setOnStart(EventHandler<MediaRecorderEvent> var1);

    public ObjectProperty<EventHandler<MediaRecorderEvent>> onStartProperty();

    public EventHandler<MediaRecorderEvent> getOnPaused();

    public void setOnPaused(EventHandler<MediaRecorderEvent> var1);

    public ObjectProperty<EventHandler<MediaRecorderEvent>> onPausedProperty();

    public EventHandler<MediaRecorderEvent> getOnResume();

    public void setOnResume(EventHandler<MediaRecorderEvent> var1);

    public ObjectProperty<EventHandler<MediaRecorderEvent>> onResumeProperty();

    public EventHandler<MediaRecorderEvent> getOnStopped();

    public void setOnStopped(EventHandler<MediaRecorderEvent> var1);

    public ObjectProperty<EventHandler<MediaRecorderEvent>> onStoppedProperty();

    public EventHandler<MediaRecorderEvent> getOnError();

    public void setOnError(EventHandler<MediaRecorderEvent> var1);

    public ObjectProperty<EventHandler<MediaRecorderEvent>> onErrorProperty();

    public MediaRecorderException getError();

    public ReadOnlyObjectProperty<MediaRecorderException> errorProperty();

    public void enable();

    public void start();

    public void pause();

    public void stop();

    public static enum Status {
        INACTIVE,
        READY,
        RECORDING,
        PAUSED;


        public static Optional<Status> fromJS(String jsStr) {
            if (jsStr != null && !jsStr.isBlank()) {
                String str = jsStr.replace("\"", "").trim();
                for (Status s : Status.values()) {
                    if (!s.name().equalsIgnoreCase(str)) continue;
                    return Optional.of(s);
                }
            }
            return Optional.empty();
        }
    }
}

