/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.recorder.impl;

import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.image.ImageView;
import one.jpro.platform.media.MediaEngine;
import one.jpro.platform.media.MediaView;
import one.jpro.platform.media.recorder.impl.FXMediaRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXMediaRecorderView
extends MediaView {
    private final Logger log = LoggerFactory.getLogger(FXMediaRecorderView.class);
    private ImageView fxFrameView;
    private final InvalidationListener updateViewContainerListener = observable -> this.updateViewContainer();
    private final WeakInvalidationListener weakUpdateViewContainerListener = new WeakInvalidationListener(this.updateViewContainerListener);

    public FXMediaRecorderView() {
        this.getStyleClass().add((Object)"media-view");
    }

    public FXMediaRecorderView(FXMediaRecorder mediaRecorder) {
        this();
        this.setMediaEngine(mediaRecorder);
    }

    @Override
    public ObjectProperty<MediaEngine> mediaEngineProperty() {
        if (this.mediaEngine == null) {
            this.mediaEngine = new SimpleObjectProperty<MediaEngine>((Object)this, "mediaEngine"){

                protected void invalidated() {
                    FXMediaRecorderView.this.sceneProperty().removeListener((InvalidationListener)FXMediaRecorderView.this.weakUpdateViewContainerListener);
                    FXMediaRecorderView.this.updateViewContainer();
                    FXMediaRecorderView.this.sceneProperty().addListener((InvalidationListener)FXMediaRecorderView.this.weakUpdateViewContainerListener);
                }
            };
        }
        return this.mediaEngine;
    }

    @Override
    public final DoubleProperty fitWidthProperty() {
        if (this.fitWidth == null) {
            this.fitWidth = new SimpleDoubleProperty((Object)this, "fitWidth"){

                protected void invalidated() {
                    FXMediaRecorderView.this.setInternalFitWidth(this.get());
                }
            };
        }
        return this.fitWidth;
    }

    @Override
    public DoubleProperty fitHeightProperty() {
        if (this.fitHeight == null) {
            this.fitHeight = new SimpleDoubleProperty((Object)this, "fitHeight"){

                protected void invalidated() {
                    FXMediaRecorderView.this.setInternalFitHeight(this.get());
                }
            };
        }
        return this.fitHeight;
    }

    @Override
    public final BooleanProperty preserveRatioProperty() {
        if (this.preserveRatio == null) {
            this.preserveRatio = new SimpleBooleanProperty((Object)this, "preserveRatio", true){

                protected void invalidated() {
                    if (FXMediaRecorderView.this.fxFrameView != null) {
                        FXMediaRecorderView.this.fxFrameView.setPreserveRatio(this.get());
                    }
                    FXMediaRecorderView.this.log.trace("preserve ratio: {}", (Object)FXMediaRecorderView.this.isPreserveRatio());
                }
            };
        }
        return this.preserveRatio;
    }

    private void setInternalFitWidth(double fitWidth) {
        if (this.fxFrameView != null) {
            if (fitWidth == 0.0) {
                this.getChildren().remove((Object)this.fxFrameView);
            } else if (!this.getChildren().contains((Object)this.fxFrameView)) {
                this.getChildren().add((Object)this.fxFrameView);
            }
            this.fxFrameView.setFitWidth(fitWidth);
            this.log.trace("video width: {}", (Object)fitWidth);
        }
    }

    private void setInternalFitHeight(double fitHeight) {
        if (this.fxFrameView != null) {
            if (fitHeight == 0.0) {
                this.getChildren().remove((Object)this.fxFrameView);
            } else if (!this.getChildren().contains((Object)this.fxFrameView)) {
                this.getChildren().add((Object)this.fxFrameView);
            }
            this.fxFrameView.setFitHeight(fitHeight);
            this.log.trace("video height: " + fitHeight);
        }
    }

    private void updateViewContainer() {
        MediaEngine mediaEngine;
        if (this.getScene() != null && (mediaEngine = this.getMediaEngine()) instanceof FXMediaRecorder) {
            FXMediaRecorder fxMediaRecorder = (FXMediaRecorder)mediaEngine;
            this.fxFrameView = fxMediaRecorder.getCameraView();
            this.fxFrameView.setPreserveRatio(this.isPreserveRatio());
            this.setInternalFitWidth(this.getFitWidth());
            this.setInternalFitHeight(this.getFitHeight());
        }
    }
}

