/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media;

import com.jpro.webapi.WebAPI;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.stage.Window;
import one.jpro.platform.media.MediaEngine;
import one.jpro.platform.media.player.MediaPlayer;
import one.jpro.platform.media.player.impl.FXMediaPlayer;
import one.jpro.platform.media.player.impl.FXMediaPlayerView;
import one.jpro.platform.media.player.impl.WebMediaPlayer;
import one.jpro.platform.media.player.impl.WebMediaPlayerView;
import one.jpro.platform.media.recorder.MediaRecorder;
import one.jpro.platform.media.recorder.impl.FXMediaRecorder;
import one.jpro.platform.media.recorder.impl.FXMediaRecorderView;
import one.jpro.platform.media.recorder.impl.WebMediaRecorder;
import one.jpro.platform.media.recorder.impl.WebMediaRecorderView;

public abstract class MediaView
extends Region {
    public static final String DEFAULT_STYLE_CLASS = "media-view";
    protected ObjectProperty<MediaEngine> mediaEngine;
    protected BooleanProperty preserveRatio;
    protected DoubleProperty fitWidth;
    protected DoubleProperty fitHeight;

    public static MediaView create(Stage stage) {
        if (WebAPI.isBrowser()) {
            WebAPI webAPI = WebAPI.getWebAPI((Window)stage);
            return new WebMediaPlayerView(webAPI);
        }
        return new FXMediaPlayerView();
    }

    public static MediaView create(MediaPlayer mediaPlayer) {
        if (mediaPlayer instanceof FXMediaPlayer) {
            FXMediaPlayer fxMediaPlayer = (FXMediaPlayer)mediaPlayer;
            return new FXMediaPlayerView(fxMediaPlayer);
        }
        if (mediaPlayer instanceof WebMediaPlayer) {
            WebMediaPlayer webMediaPlayer = (WebMediaPlayer)mediaPlayer;
            return new WebMediaPlayerView(webMediaPlayer);
        }
        throw new IllegalArgumentException("Unsupported MediaPlayer implementation: " + mediaPlayer.getClass().getName());
    }

    public static MediaView create(MediaRecorder mediaRecorder) {
        if (mediaRecorder instanceof FXMediaRecorder) {
            FXMediaRecorder fxMediaRecorder = (FXMediaRecorder)mediaRecorder;
            return new FXMediaRecorderView(fxMediaRecorder);
        }
        if (mediaRecorder instanceof WebMediaRecorder) {
            WebMediaRecorder webMediaRecorder = (WebMediaRecorder)mediaRecorder;
            return new WebMediaRecorderView(webMediaRecorder);
        }
        throw new IllegalArgumentException("Unsupported MediaRecorder implementation: " + mediaRecorder.getClass().getName());
    }

    public final MediaEngine getMediaEngine() {
        return this.mediaEngine == null ? null : (MediaEngine)this.mediaEngine.get();
    }

    public final void setMediaEngine(MediaEngine value) {
        this.mediaEngineProperty().set((Object)value);
    }

    public abstract ObjectProperty<MediaEngine> mediaEngineProperty();

    public final boolean isPreserveRatio() {
        return this.preserveRatio == null || this.preserveRatio.get();
    }

    public final void setPreserveRatio(boolean value) {
        this.preserveRatioProperty().set(value);
    }

    public abstract BooleanProperty preserveRatioProperty();

    public final double getFitWidth() {
        return this.fitWidth == null ? -1.0 : this.fitWidth.get();
    }

    public final void setFitWidth(double value) {
        this.fitWidthProperty().set(value);
    }

    public abstract DoubleProperty fitWidthProperty();

    public final double getFitHeight() {
        return this.fitHeight == null ? -1.0 : this.fitHeight.get();
    }

    public final void setFitHeight(double value) {
        this.fitHeightProperty().set(value);
    }

    public abstract DoubleProperty fitHeightProperty();

    protected void layoutChildren() {
        for (Node child : this.getManagedChildren()) {
            if (child instanceof javafx.scene.media.MediaView) {
                javafx.scene.media.MediaView fxMediaView = (javafx.scene.media.MediaView)child;
                if (this.getFitWidth() < 0.0) {
                    fxMediaView.setFitWidth(this.getWidth());
                }
                if (this.getFitHeight() < 0.0) {
                    fxMediaView.setFitHeight(this.getHeight());
                }
            }
            this.layoutInArea(child, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0, HPos.CENTER, VPos.CENTER);
        }
    }
}

