/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media;

import com.jpro.webapi.HTMLView;
import com.jpro.webapi.JSVariable;
import com.jpro.webapi.WebAPI;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import one.jpro.platform.media.MediaEngine;
import one.jpro.platform.media.MediaView;
import one.jpro.platform.media.WebMediaEngine;
import one.jpro.platform.media.recorder.impl.WebMediaRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebMediaView
extends MediaView {
    private static final Logger log = LoggerFactory.getLogger(WebMediaView.class);
    private final WebAPI webAPI;
    private JSVariable mediaContainerElement;
    private BooleanProperty showControls;
    private final InvalidationListener updateViewContainerListener = observable -> this.updateViewContainer();
    private final WeakInvalidationListener weakUpdateViewContainerListener = new WeakInvalidationListener(this.updateViewContainerListener);

    public WebMediaView(WebAPI webAPI) {
        this.webAPI = Objects.requireNonNull(webAPI, "WebAPI must not be null.");
        this.initialize();
    }

    protected void initialize() {
        this.getStyleClass().add((Object)"media-view");
        HTMLView viewContainer = new HTMLView();
        this.mediaContainerElement = this.webAPI.getHTMLViewElement(viewContainer);
        this.getChildren().setAll((Object[])new Node[]{viewContainer});
    }

    @Override
    public final ObjectProperty<MediaEngine> mediaEngineProperty() {
        if (this.mediaEngine == null) {
            this.mediaEngine = new SimpleObjectProperty<MediaEngine>((Object)this, "mediaEngine"){

                protected void invalidated() {
                    WebMediaView.this.sceneProperty().removeListener((InvalidationListener)WebMediaView.this.weakUpdateViewContainerListener);
                    WebMediaView.this.updateViewContainer();
                    WebMediaView.this.sceneProperty().addListener((InvalidationListener)WebMediaView.this.weakUpdateViewContainerListener);
                }
            };
        }
        return this.mediaEngine;
    }

    public final boolean isShowControls() {
        return this.showControls != null && this.showControls.get();
    }

    public final void setShowControls(boolean showControls) {
        this.showControlsProperty().set(showControls);
    }

    public final BooleanProperty showControlsProperty() {
        if (this.showControls == null) {
            this.showControls = new SimpleBooleanProperty((Object)this, "showControls"){

                protected void invalidated() {
                    MediaEngine mediaEngine = WebMediaView.this.getMediaEngine();
                    if (mediaEngine instanceof WebMediaEngine) {
                        WebMediaEngine webMediaEngine = (WebMediaEngine)mediaEngine;
                        WebMediaView.this.webAPI.executeScript("%s.controls = $controls;\n".formatted(webMediaEngine.getVideoElement().getName()).replace("$controls", String.valueOf(this.get())));
                    }
                }
            };
        }
        return this.showControls;
    }

    @Override
    public final DoubleProperty fitWidthProperty() {
        if (this.fitWidth == null) {
            this.fitWidth = new SimpleDoubleProperty((Object)this, "fitWidth"){

                protected void invalidated() {
                    MediaEngine mediaEngine = WebMediaView.this.getMediaEngine();
                    if (mediaEngine instanceof WebMediaEngine) {
                        WebMediaEngine webMediaEngine = (WebMediaEngine)mediaEngine;
                        WebMediaView.this.updateVideoElementWidth(webMediaEngine);
                    }
                }
            };
        }
        return this.fitWidth;
    }

    @Override
    public final DoubleProperty fitHeightProperty() {
        if (this.fitHeight == null) {
            this.fitHeight = new SimpleDoubleProperty((Object)this, "fitHeight"){

                protected void invalidated() {
                    MediaEngine mediaEngine = WebMediaView.this.getMediaEngine();
                    if (mediaEngine instanceof WebMediaEngine) {
                        WebMediaEngine webMediaEngine = (WebMediaEngine)mediaEngine;
                        WebMediaView.this.updateVideoElementHeight(webMediaEngine);
                    }
                }
            };
        }
        return this.fitHeight;
    }

    @Override
    public final BooleanProperty preserveRatioProperty() {
        if (this.preserveRatio == null) {
            this.preserveRatio = new SimpleBooleanProperty((Object)this, "preserveRatio", true){

                protected void invalidated() {
                    boolean preserveRatio = this.get();
                    MediaEngine mediaEngine = WebMediaView.this.getMediaEngine();
                    if (mediaEngine instanceof WebMediaEngine) {
                        WebMediaEngine webMediaEngine = (WebMediaEngine)mediaEngine;
                        if (preserveRatio) {
                            WebMediaView.this.webAPI.executeScript("%s.style.objectFit = 'contain';\n".formatted(webMediaEngine.getVideoElement().getName()));
                        } else {
                            WebMediaView.this.webAPI.executeScript("%s.style.objectFit = 'fill';\n".formatted(webMediaEngine.getVideoElement().getName()));
                        }
                        log.trace("preserve ratio: " + preserveRatio);
                    }
                }
            };
        }
        return this.preserveRatio;
    }

    @Override
    protected void layoutChildren() {
        for (Node child : this.getManagedChildren()) {
            MediaEngine mediaEngine = this.getMediaEngine();
            if (mediaEngine instanceof WebMediaEngine) {
                WebMediaEngine webMediaEngine = (WebMediaEngine)mediaEngine;
                this.updateVideoElementSize(webMediaEngine);
            }
            this.layoutInArea(child, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    private void updateVideoElementWidth(WebMediaEngine webMediaEngine) {
        if (this.getFitWidth() < 0.0) {
            this.webAPI.executeScript("%s.width = \"%s\";\n".formatted(webMediaEngine.getVideoElement().getName(), this.getWidth()));
        } else {
            this.webAPI.executeScript("%s.width = \"%s\";\n".formatted(webMediaEngine.getVideoElement().getName(), this.getFitWidth()));
        }
    }

    private void updateVideoElementHeight(WebMediaEngine webMediaEngine) {
        if (this.getFitHeight() < 0.0) {
            this.webAPI.executeScript("%s.height = \"%s\";\n".formatted(webMediaEngine.getVideoElement().getName(), this.getHeight()));
        } else {
            this.webAPI.executeScript("%s.height = \"%s\";\n".formatted(webMediaEngine.getVideoElement().getName(), this.getFitHeight()));
        }
    }

    private void updateVideoElementSize(WebMediaEngine webMediaEngine) {
        this.updateVideoElementWidth(webMediaEngine);
        this.updateVideoElementHeight(webMediaEngine);
    }

    private void updateViewContainer() {
        MediaEngine mediaEngine;
        if (this.getScene() != null && (mediaEngine = this.getMediaEngine()) instanceof WebMediaEngine) {
            WebMediaEngine webMediaEngine = (WebMediaEngine)mediaEngine;
            this.webAPI.executeScript("// clear all elements\nwhile ($mediaContainer.firstChild) {\n    $mediaContainer.removeChild($mediaContainer.firstChild);\n}\n// add new element\nlet videoElement = %s;\nvideoElement.controls = $controls;\n$mediaContainer.appendChild(videoElement);\n".replace("$mediaContainer", this.mediaContainerElement.getName()).replace("$controls", String.valueOf(this.isShowControls())).formatted(webMediaEngine.getVideoElement().getName()));
            this.updateVideoElementSize(webMediaEngine);
            if (webMediaEngine instanceof WebMediaRecorder) {
                this.webAPI.executeScript("let videoElement = %s;\nvideoElement.play();\n".formatted(webMediaEngine.getVideoElement().getName()));
            }
        }
    }
}

