/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.player;

import com.jpro.webapi.WebAPI;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.media.MediaPlayer;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import one.jpro.platform.media.MediaEngine;
import one.jpro.platform.media.MediaSource;
import one.jpro.platform.media.event.MediaPlayerEvent;
import one.jpro.platform.media.player.MediaPlayerException;
import one.jpro.platform.media.player.impl.FXMediaPlayer;
import one.jpro.platform.media.player.impl.WebMediaPlayer;

public interface MediaPlayer
extends MediaEngine,
EventTarget {
    public static final int INDEFINITE = -1;

    public static MediaPlayer create(Stage stage, MediaSource mediaSource) {
        if (WebAPI.isBrowser()) {
            WebAPI webAPI = WebAPI.getWebAPI((Window)stage);
            return new WebMediaPlayer(webAPI, mediaSource);
        }
        if (mediaSource.isLocal()) {
            return new FXMediaPlayer(mediaSource);
        }
        throw new IllegalArgumentException("Incorrect media source provided!");
    }

    public MediaSource getMediaSource();

    public ReadOnlyObjectProperty<MediaSource> mediaSourceProperty();

    public void setAutoPlay(boolean var1);

    public boolean isAutoPlay();

    public BooleanProperty autoPlayProperty();

    public MediaPlayer.Status getStatus();

    public ReadOnlyObjectProperty<MediaPlayer.Status> statusProperty();

    public Duration getDuration();

    public ReadOnlyObjectProperty<Duration> durationProperty();

    public double getVolume();

    public void setVolume(double var1);

    public DoubleProperty volumeProperty();

    public boolean isMute();

    public void setMute(boolean var1);

    public BooleanProperty muteProperty();

    public double getRate();

    public void setRate(double var1);

    public DoubleProperty rateProperty();

    public double getCurrentRate();

    public ReadOnlyDoubleProperty currentRateProperty();

    public Duration getCurrentTime();

    public ReadOnlyObjectProperty<Duration> currentTimeProperty();

    public Duration getStartTime();

    public void setStartTime(Duration var1);

    public ObjectProperty<Duration> startTimeProperty();

    public Duration getStopTime();

    public void setStopTime(Duration var1);

    public ObjectProperty<Duration> stopTimeProperty();

    public int getCycleCount();

    public void setCycleCount(int var1);

    public IntegerProperty cycleCountProperty();

    public int getCurrentCount();

    public ReadOnlyIntegerProperty currentCountProperty();

    public Duration getCycleDuration();

    public ReadOnlyObjectProperty<Duration> cycleDurationProperty();

    public Duration getTotalDuration();

    public ReadOnlyObjectProperty<Duration> totalDurationProperty();

    public EventHandler<MediaPlayerEvent> getOnReady();

    public void setOnReady(EventHandler<MediaPlayerEvent> var1);

    public ObjectProperty<EventHandler<MediaPlayerEvent>> onReadyProperty();

    public EventHandler<MediaPlayerEvent> getOnPlaying();

    public void setOnPlaying(EventHandler<MediaPlayerEvent> var1);

    public ObjectProperty<EventHandler<MediaPlayerEvent>> onPlayingProperty();

    public EventHandler<MediaPlayerEvent> getOnPaused();

    public void setOnPaused(EventHandler<MediaPlayerEvent> var1);

    public ObjectProperty<EventHandler<MediaPlayerEvent>> onPausedProperty();

    public EventHandler<MediaPlayerEvent> getOnStopped();

    public void setOnStopped(EventHandler<MediaPlayerEvent> var1);

    public ObjectProperty<EventHandler<MediaPlayerEvent>> onStoppedProperty();

    public EventHandler<MediaPlayerEvent> getOnStalled();

    public void setOnStalled(EventHandler<MediaPlayerEvent> var1);

    public ObjectProperty<EventHandler<MediaPlayerEvent>> onStalledProperty();

    public EventHandler<MediaPlayerEvent> getOnEndOfMedia();

    public void setOnEndOfMedia(EventHandler<MediaPlayerEvent> var1);

    public ObjectProperty<EventHandler<MediaPlayerEvent>> onEndOfMediaProperty();

    public EventHandler<MediaPlayerEvent> getOnRepeat();

    public void setOnRepeat(EventHandler<MediaPlayerEvent> var1);

    public ObjectProperty<EventHandler<MediaPlayerEvent>> onRepeatProperty();

    public EventHandler<MediaPlayerEvent> getOnError();

    public void setOnError(EventHandler<MediaPlayerEvent> var1);

    public ObjectProperty<EventHandler<MediaPlayerEvent>> onErrorProperty();

    public MediaPlayerException getError();

    public ReadOnlyObjectProperty<MediaPlayerException> errorProperty();

    public void play();

    public void pause();

    public void stop();

    public void seek(Duration var1);
}

