/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.player.impl;

import com.sun.javafx.event.EventHandlerManager;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import one.jpro.platform.media.MediaSource;
import one.jpro.platform.media.event.MediaPlayerEvent;
import one.jpro.platform.media.player.MediaPlayer;
import one.jpro.platform.media.player.MediaPlayerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseMediaPlayer
implements MediaPlayer {
    private final Logger log = LoggerFactory.getLogger(BaseMediaPlayer.class);
    boolean isEOS = false;
    ReadOnlyObjectWrapper<MediaSource> mediaSource;
    BooleanProperty autoPlay;
    private ReadOnlyObjectWrapper<MediaPlayer.Status> status;
    private ReadOnlyObjectWrapper<Duration> currentTime;
    private IntegerProperty cycleCount;
    private ReadOnlyIntegerWrapper currentCount;
    private ReadOnlyObjectWrapper<Duration> cycleDuration;
    private ReadOnlyObjectWrapper<Duration> duration;
    private ReadOnlyObjectWrapper<Duration> totalDuration;
    private ObjectProperty<EventHandler<MediaPlayerEvent>> onReady;
    private ObjectProperty<EventHandler<MediaPlayerEvent>> onPlaying;
    private ObjectProperty<EventHandler<MediaPlayerEvent>> onPaused;
    private ObjectProperty<EventHandler<MediaPlayerEvent>> onStalled;
    private ObjectProperty<EventHandler<MediaPlayerEvent>> onStopped;
    private ObjectProperty<EventHandler<MediaPlayerEvent>> onEndOfMedia;
    private ObjectProperty<EventHandler<MediaPlayerEvent>> onRepeat;
    private ObjectProperty<EventHandler<MediaPlayerEvent>> onError;
    private ReadOnlyObjectWrapper<MediaPlayerException> error;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);

    BaseMediaPlayer() {
    }

    @Override
    public final MediaSource getMediaSource() {
        return this.mediaSource == null ? null : (MediaSource)this.mediaSource.get();
    }

    final void setMediaSource(MediaSource value) {
        this.mediaSourcePropertyImpl().set((Object)value);
    }

    @Override
    public final ReadOnlyObjectProperty<MediaSource> mediaSourceProperty() {
        return this.mediaSourcePropertyImpl().getReadOnlyProperty();
    }

    abstract ReadOnlyObjectWrapper<MediaSource> mediaSourcePropertyImpl();

    @Override
    public void setAutoPlay(boolean value) {
        this.autoPlayProperty().set(value);
    }

    @Override
    public boolean isAutoPlay() {
        return this.autoPlay != null && this.autoPlay.get();
    }

    @Override
    public abstract BooleanProperty autoPlayProperty();

    @Override
    public MediaPlayer.Status getStatus() {
        return this.status == null ? MediaPlayer.Status.UNKNOWN : (MediaPlayer.Status)this.status.get();
    }

    void setStatus(MediaPlayer.Status value) {
        this.statusPropertyImpl().set((Object)value);
    }

    @Override
    public ReadOnlyObjectProperty<MediaPlayer.Status> statusProperty() {
        return this.statusPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<MediaPlayer.Status> statusPropertyImpl() {
        if (this.status == null) {
            this.status = new ReadOnlyObjectWrapper<MediaPlayer.Status>((Object)this, "status", MediaPlayer.Status.UNKNOWN){

                protected void invalidated() {
                    BaseMediaPlayer.this.log.trace("Status changed to: {}", this.get());
                }
            };
        }
        return this.status;
    }

    @Override
    public Duration getCurrentTime() {
        if (this.getStatus() == MediaPlayer.Status.DISPOSED) {
            return Duration.ZERO;
        }
        if (this.getStatus() == MediaPlayer.Status.STOPPED) {
            return Duration.millis((double)this.getStartTime().toMillis());
        }
        if (this.isEOS) {
            Duration duration = this.getDuration();
            Duration stopTime = this.getStopTime();
            if (stopTime != Duration.UNKNOWN && duration != Duration.UNKNOWN) {
                if (stopTime.greaterThan(duration)) {
                    return Duration.millis((double)duration.toMillis());
                }
                return Duration.millis((double)stopTime.toMillis());
            }
        }
        return this.currentTime == null ? Duration.ZERO : (Duration)this.currentTime.get();
    }

    void setCurrentTime(Duration value) {
        this.currentTimePropertyImpl().set((Object)value);
    }

    @Override
    public ReadOnlyObjectProperty<Duration> currentTimeProperty() {
        return this.currentTimePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Duration> currentTimePropertyImpl() {
        if (this.currentTime == null) {
            this.currentTime = new ReadOnlyObjectWrapper<Duration>((Object)this, "currentTime", Duration.ZERO){

                protected void invalidated() {
                    BaseMediaPlayer.this.log.trace("Current time updated: {} s", (Object)((Duration)this.get()).toSeconds());
                }
            };
        }
        return this.currentTime;
    }

    @Override
    public int getCycleCount() {
        return this.cycleCount == null ? 1 : this.cycleCount.get();
    }

    @Override
    public void setCycleCount(int value) {
        this.cycleCountProperty().set(value);
    }

    @Override
    public IntegerProperty cycleCountProperty() {
        if (this.cycleCount == null) {
            this.cycleCount = new SimpleIntegerProperty((Object)this, "cycleCount", 1);
        }
        return this.cycleCount;
    }

    @Override
    public final int getCurrentCount() {
        return this.currentCount == null ? 0 : this.currentCount.get();
    }

    void setCurrentCount(int value) {
        this.currentCountPropertyImpl().set(value);
    }

    @Override
    public ReadOnlyIntegerProperty currentCountProperty() {
        return this.currentCountPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyIntegerWrapper currentCountPropertyImpl() {
        if (this.currentCount == null) {
            this.currentCount = new ReadOnlyIntegerWrapper((Object)this, "currentCount");
        }
        return this.currentCount;
    }

    @Override
    public Duration getCycleDuration() {
        return this.cycleDuration == null ? Duration.UNKNOWN : (Duration)this.cycleDuration.get();
    }

    void setCycleDuration(Duration value) {
        this.cycleDurationPropertyImpl().set((Object)value);
    }

    @Override
    public ReadOnlyObjectProperty<Duration> cycleDurationProperty() {
        return this.cycleDurationPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Duration> cycleDurationPropertyImpl() {
        if (this.cycleDuration == null) {
            this.cycleDuration = new ReadOnlyObjectWrapper((Object)this, "cycleDuration");
        }
        return this.cycleDuration;
    }

    @Override
    public Duration getDuration() {
        return this.duration == null ? Duration.UNKNOWN : (Duration)this.duration.get();
    }

    void setDuration(Duration value) {
        this.durationPropertyImpl().set((Object)value);
    }

    @Override
    public ReadOnlyObjectProperty<Duration> durationProperty() {
        return this.durationPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Duration> durationPropertyImpl() {
        if (this.duration == null) {
            this.duration = new ReadOnlyObjectWrapper<Duration>((Object)this, "duration", Duration.UNKNOWN){

                protected void invalidated() {
                    BaseMediaPlayer.this.log.trace("Media duration: {} s", (Object)((Duration)this.get()).toSeconds());
                }
            };
        }
        return this.duration;
    }

    @Override
    public Duration getTotalDuration() {
        return this.totalDuration == null ? Duration.UNKNOWN : (Duration)this.totalDuration.get();
    }

    void setTotalDuration(Duration value) {
        this.totalDurationPropertyImpl().set((Object)value);
    }

    @Override
    public ReadOnlyObjectProperty<Duration> totalDurationProperty() {
        return this.totalDurationPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Duration> totalDurationPropertyImpl() {
        if (this.totalDuration == null) {
            this.totalDuration = new ReadOnlyObjectWrapper((Object)this, "totalDuration");
        }
        return this.totalDuration;
    }

    @Override
    public final EventHandler<MediaPlayerEvent> getOnReady() {
        return this.onReady == null ? null : (EventHandler)this.onReady.get();
    }

    @Override
    public final void setOnReady(EventHandler<MediaPlayerEvent> value) {
        this.onReadyProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaPlayerEvent>> onReadyProperty() {
        if (this.onReady == null) {
            this.onReady = new SimpleObjectProperty<EventHandler<MediaPlayerEvent>>((Object)this, "onReady"){

                protected void invalidated() {
                    BaseMediaPlayer.this.eventHandlerManager.setEventHandler(MediaPlayerEvent.MEDIA_PLAYER_READY, (EventHandler)this.get());
                }
            };
        }
        return this.onReady;
    }

    @Override
    public final EventHandler<MediaPlayerEvent> getOnPlaying() {
        return this.onPlaying == null ? null : (EventHandler)this.onPlaying.get();
    }

    @Override
    public final void setOnPlaying(EventHandler<MediaPlayerEvent> value) {
        this.onPlayingProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaPlayerEvent>> onPlayingProperty() {
        if (this.onPlaying == null) {
            this.onPlaying = new SimpleObjectProperty<EventHandler<MediaPlayerEvent>>((Object)this, "onPlaying"){

                protected void invalidated() {
                    BaseMediaPlayer.this.eventHandlerManager.setEventHandler(MediaPlayerEvent.MEDIA_PLAYER_PLAY, (EventHandler)this.get());
                }
            };
        }
        return this.onPlaying;
    }

    @Override
    public final EventHandler<MediaPlayerEvent> getOnPaused() {
        return this.onPaused == null ? null : (EventHandler)this.onPaused.get();
    }

    @Override
    public final void setOnPaused(EventHandler<MediaPlayerEvent> value) {
        this.onPausedProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaPlayerEvent>> onPausedProperty() {
        if (this.onPaused == null) {
            this.onPaused = new SimpleObjectProperty<EventHandler<MediaPlayerEvent>>((Object)this, "onPaused"){

                protected void invalidated() {
                    BaseMediaPlayer.this.eventHandlerManager.setEventHandler(MediaPlayerEvent.MEDIA_PLAYER_PAUSE, (EventHandler)this.get());
                }
            };
        }
        return this.onPaused;
    }

    @Override
    public final EventHandler<MediaPlayerEvent> getOnStalled() {
        return this.onStalled == null ? null : (EventHandler)this.onStalled.get();
    }

    @Override
    public final void setOnStalled(EventHandler<MediaPlayerEvent> value) {
        this.onStalledProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaPlayerEvent>> onStalledProperty() {
        if (this.onStalled == null) {
            this.onStalled = new SimpleObjectProperty<EventHandler<MediaPlayerEvent>>((Object)this, "onStalled"){

                protected void invalidated() {
                    BaseMediaPlayer.this.eventHandlerManager.setEventHandler(MediaPlayerEvent.MEDIA_PLAYER_STALLED, (EventHandler)this.get());
                }
            };
        }
        return this.onStalled;
    }

    @Override
    public final EventHandler<MediaPlayerEvent> getOnStopped() {
        return this.onStopped == null ? null : (EventHandler)this.onStopped.get();
    }

    @Override
    public final void setOnStopped(EventHandler<MediaPlayerEvent> value) {
        this.onStoppedProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaPlayerEvent>> onStoppedProperty() {
        if (this.onStopped == null) {
            this.onStopped = new SimpleObjectProperty<EventHandler<MediaPlayerEvent>>((Object)this, "onStopped"){

                protected void invalidated() {
                    BaseMediaPlayer.this.eventHandlerManager.setEventHandler(MediaPlayerEvent.MEDIA_PLAYER_STOP, (EventHandler)this.get());
                }
            };
        }
        return this.onStopped;
    }

    @Override
    public final EventHandler<MediaPlayerEvent> getOnEndOfMedia() {
        return this.onEndOfMedia == null ? null : (EventHandler)this.onEndOfMedia.get();
    }

    @Override
    public final void setOnEndOfMedia(EventHandler<MediaPlayerEvent> value) {
        this.onEndOfMediaProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaPlayerEvent>> onEndOfMediaProperty() {
        if (this.onEndOfMedia == null) {
            this.onEndOfMedia = new SimpleObjectProperty<EventHandler<MediaPlayerEvent>>((Object)this, "onEndOfMedia"){

                protected void invalidated() {
                    BaseMediaPlayer.this.eventHandlerManager.setEventHandler(MediaPlayerEvent.MEDIA_PLAYER_END_OF_MEDIA, (EventHandler)this.get());
                }
            };
        }
        return this.onEndOfMedia;
    }

    @Override
    public final EventHandler<MediaPlayerEvent> getOnRepeat() {
        return this.onRepeat == null ? null : (EventHandler)this.onRepeat.get();
    }

    @Override
    public final void setOnRepeat(EventHandler<MediaPlayerEvent> value) {
        this.onRepeatProperty().set(value);
    }

    @Override
    public ObjectProperty<EventHandler<MediaPlayerEvent>> onRepeatProperty() {
        if (this.onRepeat == null) {
            this.onRepeat = new SimpleObjectProperty<EventHandler<MediaPlayerEvent>>((Object)this, "onRepeat"){

                protected void invalidated() {
                    BaseMediaPlayer.this.eventHandlerManager.setEventHandler(MediaPlayerEvent.MEDIA_PLAYER_REPEAT, (EventHandler)this.get());
                }
            };
        }
        return this.onRepeat;
    }

    @Override
    public final EventHandler<MediaPlayerEvent> getOnError() {
        return this.onError == null ? null : (EventHandler)this.onError.get();
    }

    @Override
    public final void setOnError(EventHandler<MediaPlayerEvent> value) {
        this.onErrorProperty().set(value);
    }

    @Override
    public final ObjectProperty<EventHandler<MediaPlayerEvent>> onErrorProperty() {
        if (this.onError == null) {
            this.onError = new SimpleObjectProperty<EventHandler<MediaPlayerEvent>>((Object)this, "onError"){

                protected void invalidated() {
                    BaseMediaPlayer.this.eventHandlerManager.setEventHandler(MediaPlayerEvent.MEDIA_PLAYER_ERROR, (EventHandler)this.get());
                }
            };
        }
        return this.onError;
    }

    @Override
    public final MediaPlayerException getError() {
        return this.error == null ? null : (MediaPlayerException)this.error.get();
    }

    final void setError(MediaPlayerException error) {
        this.errorPropertyImpl().set((Object)error);
    }

    @Override
    public final ReadOnlyObjectProperty<MediaPlayerException> errorProperty() {
        return this.errorPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<MediaPlayerException> errorPropertyImpl() {
        if (this.error == null) {
            this.error = new ReadOnlyObjectWrapper<MediaPlayerException>((Object)this, "error"){

                protected void invalidated() {
                    MediaPlayerException exception = (MediaPlayerException)this.get();
                    if (exception != null) {
                        Event.fireEvent((EventTarget)BaseMediaPlayer.this, (Event)new MediaPlayerEvent(BaseMediaPlayer.this, MediaPlayerEvent.MEDIA_PLAYER_ERROR));
                    }
                }
            };
        }
        return this.error;
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return tail.prepend((EventDispatcher)this.eventHandlerManager);
    }
}

