/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.player.impl;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import one.jpro.platform.media.MediaSource;
import one.jpro.platform.media.event.MediaPlayerEvent;
import one.jpro.platform.media.player.MediaPlayerException;
import one.jpro.platform.media.player.impl.BaseMediaPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FXMediaPlayer
extends BaseMediaPlayer {
    private final Logger log = LoggerFactory.getLogger(FXMediaPlayer.class);
    private final Media media;
    private final MediaPlayer mediaPlayer;
    private volatile boolean eom = false;

    public FXMediaPlayer(MediaSource mediaSource) {
        this.setMediaSource(mediaSource);
        this.media = new Media(mediaSource.source());
        this.mediaPlayer = new MediaPlayer(this.media);
        this.mediaPlayer.setOnReady(() -> {
            this.setStatus(MediaPlayer.Status.READY);
            Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_READY));
        });
        this.mediaPlayer.setOnPlaying(() -> {
            this.setStatus(MediaPlayer.Status.PLAYING);
            Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_PLAY));
        });
        this.mediaPlayer.setOnPaused(() -> {
            this.setStatus(MediaPlayer.Status.PAUSED);
            Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_PAUSE));
        });
        this.mediaPlayer.setOnStopped(() -> {
            this.setStatus(MediaPlayer.Status.STOPPED);
            Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_STOP));
        });
        this.mediaPlayer.setOnEndOfMedia(() -> {
            this.eom = true;
            this.setStatus(MediaPlayer.Status.PAUSED);
            Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_PAUSE));
            Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_END_OF_MEDIA));
        });
        this.mediaPlayer.setOnRepeat(() -> Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_REPEAT)));
        this.mediaPlayer.setOnError(() -> {
            this.setStatus(MediaPlayer.Status.HALTED);
            this.setError(new MediaPlayerException(this.mediaPlayer.getError().getMessage(), (Throwable)this.mediaPlayer.getError()));
        });
        this.mediaPlayer.statusProperty().addListener(observable -> this.setStatus(this.mediaPlayer.getStatus()));
        this.mediaPlayer.currentTimeProperty().addListener(observable -> this.log.trace("Current time: {} seconds", (Object)this.mediaPlayer.getCurrentTime().toSeconds()));
        this.mediaPlayer.volumeProperty().addListener(observable -> this.log.trace("Volume: {}", (Object)this.mediaPlayer.getVolume()));
    }

    public MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    @Override
    ReadOnlyObjectWrapper<MediaSource> mediaSourcePropertyImpl() {
        if (this.mediaSource == null) {
            this.mediaSource = new ReadOnlyObjectWrapper((Object)this, "mediaSource");
        }
        return this.mediaSource;
    }

    @Override
    public boolean isAutoPlay() {
        return this.mediaPlayer.isAutoPlay();
    }

    @Override
    public void setAutoPlay(boolean autoPlay) {
        this.mediaPlayer.setAutoPlay(autoPlay);
    }

    @Override
    public BooleanProperty autoPlayProperty() {
        return this.mediaPlayer.autoPlayProperty();
    }

    @Override
    public Duration getStartTime() {
        return this.mediaPlayer.getStartTime();
    }

    @Override
    public void setStartTime(Duration startTime) {
        this.mediaPlayer.setStartTime(startTime);
    }

    @Override
    public ObjectProperty<Duration> startTimeProperty() {
        return this.mediaPlayer.startTimeProperty();
    }

    @Override
    public Duration getStopTime() {
        return this.mediaPlayer.getStopTime();
    }

    @Override
    public void setStopTime(Duration stopTime) {
        this.mediaPlayer.setStopTime(stopTime);
    }

    @Override
    public ObjectProperty<Duration> stopTimeProperty() {
        return this.mediaPlayer.stopTimeProperty();
    }

    @Override
    public int getCycleCount() {
        return this.mediaPlayer.getCycleCount();
    }

    @Override
    public void setCycleCount(int cycleCount) {
        this.mediaPlayer.setCycleCount(cycleCount);
    }

    @Override
    public IntegerProperty cycleCountProperty() {
        return this.mediaPlayer.cycleCountProperty();
    }

    @Override
    public Duration getCycleDuration() {
        return this.mediaPlayer.getCycleDuration();
    }

    @Override
    public ReadOnlyObjectProperty<Duration> cycleDurationProperty() {
        return this.mediaPlayer.cycleDurationProperty();
    }

    @Override
    public Duration getDuration() {
        return this.media.getDuration();
    }

    @Override
    public ReadOnlyObjectProperty<Duration> durationProperty() {
        return this.media.durationProperty();
    }

    @Override
    public Duration getTotalDuration() {
        return this.mediaPlayer.getTotalDuration();
    }

    @Override
    public ReadOnlyObjectProperty<Duration> totalDurationProperty() {
        return this.mediaPlayer.totalDurationProperty();
    }

    @Override
    public Duration getCurrentTime() {
        return this.mediaPlayer.getCurrentTime();
    }

    @Override
    public ReadOnlyObjectProperty<Duration> currentTimeProperty() {
        return this.mediaPlayer.currentTimeProperty();
    }

    @Override
    public double getVolume() {
        return this.mediaPlayer.getVolume();
    }

    @Override
    public void setVolume(double value) {
        this.mediaPlayer.setVolume(value);
    }

    @Override
    public DoubleProperty volumeProperty() {
        return this.mediaPlayer.volumeProperty();
    }

    @Override
    public boolean isMute() {
        return this.mediaPlayer.isMute();
    }

    @Override
    public void setMute(boolean value) {
        this.mediaPlayer.setMute(value);
    }

    @Override
    public BooleanProperty muteProperty() {
        return this.mediaPlayer.muteProperty();
    }

    @Override
    public double getRate() {
        return this.mediaPlayer.getRate();
    }

    @Override
    public void setRate(double value) {
        this.mediaPlayer.setRate(value);
    }

    @Override
    public DoubleProperty rateProperty() {
        return this.mediaPlayer.rateProperty();
    }

    @Override
    public double getCurrentRate() {
        return this.mediaPlayer.getCurrentRate();
    }

    @Override
    public ReadOnlyDoubleProperty currentRateProperty() {
        return this.mediaPlayer.currentRateProperty();
    }

    @Override
    public void play() {
        if (this.eom) {
            this.mediaPlayer.seek(Duration.ZERO);
            if (this.mediaPlayer.getStatus() == MediaPlayer.Status.PLAYING) {
                this.setStatus(MediaPlayer.Status.PLAYING);
                Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_PLAY));
            }
            this.eom = false;
        }
        this.mediaPlayer.play();
    }

    @Override
    public void pause() {
        this.mediaPlayer.pause();
    }

    @Override
    public void stop() {
        this.mediaPlayer.stop();
    }

    @Override
    public void seek(Duration seekTime) {
        if (seekTime == null) {
            this.setError(new MediaPlayerException("Seek time is null."));
        } else {
            Duration duration;
            if (seekTime.isUnknown()) {
                this.setError(new MediaPlayerException("Seek time is unknown."));
                return;
            }
            if (seekTime.lessThan(Duration.ZERO)) {
                this.setError(new MediaPlayerException("Seek time is negative. The value will be clamp to zero."));
                seekTime = Duration.ZERO;
            }
            if ((duration = this.getDuration()) != null && seekTime.greaterThan(duration)) {
                this.setError(new MediaPlayerException("Seek time is greater than duration."));
                return;
            }
            this.mediaPlayer.seek(seekTime);
            if (this.eom) {
                this.mediaPlayer.pause();
                this.eom = false;
            }
        }
    }
}

