/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.player.impl;

import com.jpro.webapi.JSVariable;
import com.jpro.webapi.WebAPI;
import com.jpro.webapi.WebCallback;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import one.jpro.platform.media.MediaSource;
import one.jpro.platform.media.WebMediaEngine;
import one.jpro.platform.media.event.MediaPlayerEvent;
import one.jpro.platform.media.player.MediaPlayerException;
import one.jpro.platform.media.player.impl.BaseMediaPlayer;
import one.jpro.platform.media.player.impl.WebMediaError;
import one.jpro.platform.media.player.impl.WebReadyState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebMediaPlayer
extends BaseMediaPlayer
implements WebMediaEngine {
    private static final Logger log = LoggerFactory.getLogger(WebMediaPlayer.class);
    private static final double RATE_MIN = 0.0;
    private static final double RATE_MAX = 8.0;
    private final WebAPI webAPI;
    private final String mediaPlayerId;
    private final JSVariable playerVideoElement;
    private boolean playerReady = false;
    private boolean startTimeChangeRequested = false;
    private boolean stopTimeChangeRequested = false;
    private ObjectProperty<Duration> startTime;
    private ObjectProperty<Duration> stopTime;
    private ReadOnlyObjectWrapper<WebReadyState> readyState;
    private DoubleProperty volume;
    private BooleanProperty muted;
    private DoubleProperty rate;
    private ReadOnlyDoubleWrapper currentRate;

    public WebMediaPlayer(WebAPI webAPI, MediaSource mediaSource) {
        this.webAPI = Objects.requireNonNull(webAPI, "WebAPI cannot be null.");
        this.mediaPlayerId = webAPI.createUniqueJSName("media_player_");
        this.playerVideoElement = this.createPlayerVideoElement("video_elem_" + this.mediaPlayerId);
        this.setMediaSource(Objects.requireNonNull(mediaSource, "Media source cannot be null."));
        this.handleWebEvent("loadeddata", "    console.log(\"$mediaPlayerId => ready state: \" + elem.readyState);\n    java_fun(elem.readyState);\n", readyState -> WebReadyState.fromCode(Integer.parseInt(readyState)).ifPresent(this::setReadyState));
        this.handleWebEvent("timeupdate", "console.log(\"$mediaPlayerId => current time: \" + elem.currentTime);\njava_fun(elem.currentTime);\n", currentTime -> {
            Duration theCurrentTime = Duration.seconds((double)Double.parseDouble(currentTime));
            this.setCurrentTime(theCurrentTime);
            Duration stopTime = this.getStopTime();
            if (stopTime != Duration.UNKNOWN && this.getCurrentTime().greaterThan(this.getStopTime())) {
                this.setCurrentCount(this.getCurrentCount() + 1);
                if (this.getCurrentCount() < this.getCycleCount() || this.getCycleCount() == -1) {
                    Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_END_OF_MEDIA));
                    this.seek(this.getStartTime());
                    Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_REPEAT));
                } else {
                    this.isEOS = true;
                    this.pause();
                }
            }
        });
        this.handleWebEvent("durationchange", "console.log(\"$mediaPlayerId => media duration: \" + elem.duration + \" seconds\");\njava_fun(elem.duration);\n", duration -> {
            if (duration != null && !duration.contains("null")) {
                this.setDuration(Duration.seconds((double)Double.parseDouble(duration)));
            } else {
                this.setDuration(Duration.UNKNOWN);
            }
        });
        this.handleWebEvent("volumechange", "console.log(\"$mediaPlayerId => volume change: \" + elem.volume);\njava_fun(elem.volume);\n", volume -> this.volumeProperty().set(Double.parseDouble(volume)));
        this.handleWebEvent("ratechange", "console.log(\"$mediaPlayerId => rate change: \" + elem.playbackRate);\njava_fun(elem.playbackRate);\n", rate -> this.setCurrentRate(Double.parseDouble(rate)));
        this.handleWebEvent("play", "    console.log(\"$mediaPlayerId => playing...\");\n    java_fun(elem.currentTime);\n", currentTime -> {
            this.setStatus(MediaPlayer.Status.PLAYING);
            this.setCurrentRate(this.getRate());
            Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_PLAY));
        });
        this.handleWebEvent("pause", "    console.log(\"$mediaPlayerId => paused...\");\n    java_fun(elem.paused);\n", paused -> {
            if (Boolean.parseBoolean(paused)) {
                this.setStatus(MediaPlayer.Status.PAUSED);
                this.setCurrentRate(0.0);
                Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_PAUSE));
                if (this.isEOS) {
                    Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_END_OF_MEDIA));
                }
            }
        });
        this.handleWebEvent("stalled", "    console.log(\"$mediaPlayerId => stalled...\");\n    java_fun(elem.readyState);\n", readyState -> {
            log.trace("Media player stalled: {}", (Object)readyState);
            this.setStatus(MediaPlayer.Status.STALLED);
            this.setCurrentRate(0.0);
            Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_STALLED));
        });
        this.handleWebEvent("ended", "    console.log(\"$mediaPlayerId => ended...\");\n    java_fun(elem.ended);\n", ended -> {
            if (Boolean.parseBoolean(ended)) {
                this.isEOS = true;
                this.setCurrentRate(0.0);
                Event.fireEvent((EventTarget)this, (Event)new MediaPlayerEvent(this, MediaPlayerEvent.MEDIA_PLAYER_END_OF_MEDIA));
            }
        });
        this.handleWebEvent("error", "    console.log(\"$mediaPlayerId => error occurred with code: \" + elem.error.code);\n    java_fun(elem.error.code);\n", errorCode -> {
            this.setStatus(MediaPlayer.Status.HALTED);
            this.setCurrentRate(0.0);
            WebMediaError.fromCode(Integer.parseInt(errorCode)).ifPresent(webErrorCode -> this.setError(new MediaPlayerException(webErrorCode.getDescription())));
        });
    }

    @Override
    public WebAPI getWebAPI() {
        return this.webAPI;
    }

    @Override
    public JSVariable getVideoElement() {
        return this.playerVideoElement;
    }

    @Override
    ReadOnlyObjectWrapper<MediaSource> mediaSourcePropertyImpl() {
        if (this.mediaSource == null) {
            this.mediaSource = new ReadOnlyObjectWrapper<MediaSource>((Object)this, "mediaSource"){

                protected void invalidated() {
                    if (WebMediaPlayer.this.getStatus() != MediaPlayer.Status.DISPOSED) {
                        WebMediaPlayer.this.webAPI.executeScript("%s.src = \"$source\";\n".formatted(WebMediaPlayer.this.playerVideoElement.getName()).replace("$source", ((MediaSource)this.get()).source()).replace("\"\"", "\""));
                    }
                }
            };
        }
        return this.mediaSource;
    }

    @Override
    public Duration getStartTime() {
        return this.startTime == null ? Duration.ZERO : (Duration)this.startTime.get();
    }

    @Override
    public void setStartTime(Duration value) {
        this.startTimeProperty().set((Object)value);
    }

    @Override
    public ObjectProperty<Duration> startTimeProperty() {
        if (this.startTime == null) {
            this.startTime = new SimpleObjectProperty<Duration>((Object)this, "startTime", Duration.ZERO){

                protected void invalidated() {
                    if (WebMediaPlayer.this.getStatus() != MediaPlayer.Status.DISPOSED) {
                        if (WebMediaPlayer.this.playerReady) {
                            WebMediaPlayer.this.setStartStopTimes(WebMediaPlayer.this.getStartTime(), true, WebMediaPlayer.this.getStopTime(), false);
                        } else {
                            WebMediaPlayer.this.startTimeChangeRequested = true;
                        }
                        WebMediaPlayer.this.calculateCycleDuration();
                    }
                }
            };
        }
        return this.startTime;
    }

    @Override
    public Duration getStopTime() {
        return this.stopTime == null ? this.getDuration() : (Duration)this.stopTime.get();
    }

    @Override
    public void setStopTime(Duration value) {
        this.stopTimeProperty().set((Object)value);
    }

    @Override
    public ObjectProperty<Duration> stopTimeProperty() {
        if (this.stopTime == null) {
            this.stopTime = new SimpleObjectProperty<Duration>((Object)this, "stopTime", this.getDuration()){

                protected void invalidated() {
                    if (WebMediaPlayer.this.getStatus() != MediaPlayer.Status.DISPOSED) {
                        if (WebMediaPlayer.this.playerReady) {
                            WebMediaPlayer.this.setStartStopTimes(WebMediaPlayer.this.getStartTime(), false, (Duration)WebMediaPlayer.this.stopTime.get(), true);
                        } else {
                            WebMediaPlayer.this.stopTimeChangeRequested = true;
                        }
                        WebMediaPlayer.this.calculateCycleDuration();
                    }
                }
            };
        }
        return this.stopTime;
    }

    @Override
    public BooleanProperty autoPlayProperty() {
        if (this.autoPlay == null) {
            this.autoPlay = new SimpleBooleanProperty(this, "autoPlay"){

                protected void invalidated() {
                    if (WebMediaPlayer.this.getStatus() != MediaPlayer.Status.DISPOSED) {
                        WebMediaPlayer.this.webAPI.executeScript("%s.autoplay = $autoplay;\n".formatted(WebMediaPlayer.this.playerVideoElement.getName()).replace("$autoplay", String.valueOf(this.get())));
                    }
                }
            };
        }
        return this.autoPlay;
    }

    public WebReadyState getReadyState() {
        return this.readyState == null ? WebReadyState.HAVE_NOTHING : (WebReadyState)((Object)this.readyState.get());
    }

    private void setReadyState(WebReadyState value) {
        this.readyStatePropertyImpl().set((Object)value);
    }

    public ReadOnlyObjectProperty<WebReadyState> readyStateProperty() {
        return this.readyStatePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<WebReadyState> readyStatePropertyImpl() {
        if (this.readyState == null) {
            this.readyState = new ReadOnlyObjectWrapper<WebReadyState>((Object)this, "readyState"){

                protected void invalidated() {
                    if (((WebReadyState)((Object)this.get())).getCode() >= WebReadyState.HAVE_METADATA.getCode()) {
                        WebMediaPlayer.this.playerReady = true;
                        WebMediaPlayer.this.setStatus(MediaPlayer.Status.READY);
                        WebMediaPlayer.this.handleRequestedChanges();
                        Event.fireEvent((EventTarget)WebMediaPlayer.this, (Event)new MediaPlayerEvent(WebMediaPlayer.this, MediaPlayerEvent.MEDIA_PLAYER_READY));
                    }
                    log.trace("Ready state changed: {}", this.get());
                }
            };
        }
        return this.readyState;
    }

    @Override
    public double getVolume() {
        return this.volume == null ? 1.0 : this.volume.get();
    }

    @Override
    public void setVolume(double value) {
        value = this.clamp(value, 0.0, 1.0);
        if (this.getStatus() != MediaPlayer.Status.DISPOSED) {
            this.webAPI.executeScript("%s.volume = %s;\n".formatted(this.playerVideoElement.getName(), value));
        }
        this.volumeProperty().set(value);
    }

    @Override
    public DoubleProperty volumeProperty() {
        if (this.volume == null) {
            this.volume = new SimpleDoubleProperty(this, "volume", 1.0){

                protected void invalidated() {
                    log.trace("Volume changed: {}", (Object)this.get());
                }
            };
        }
        return this.volume;
    }

    @Override
    public boolean isMute() {
        return this.muted != null && this.muted.get();
    }

    @Override
    public void setMute(boolean value) {
        this.muteProperty().set(value);
    }

    @Override
    public BooleanProperty muteProperty() {
        if (this.muted == null) {
            this.muted = new SimpleBooleanProperty(this, "muted"){

                protected void invalidated() {
                    if (WebMediaPlayer.this.getStatus() != MediaPlayer.Status.DISPOSED) {
                        WebMediaPlayer.this.webAPI.executeScript("%s.muted = $muted;\n".formatted(WebMediaPlayer.this.playerVideoElement.getName()).replace("$muted", String.valueOf(this.get())));
                    }
                }
            };
        }
        return this.muted;
    }

    @Override
    public double getRate() {
        return this.rate == null ? 1.0 : this.rate.get();
    }

    @Override
    public void setRate(double value) {
        this.rateProperty().set(value);
    }

    @Override
    public DoubleProperty rateProperty() {
        if (this.rate == null) {
            this.rate = new SimpleDoubleProperty(this, "rate", 1.0){

                protected void invalidated() {
                    if (WebMediaPlayer.this.getStatus() != MediaPlayer.Status.DISPOSED) {
                        double rate = WebMediaPlayer.this.clamp(this.get(), 0.0, 8.0);
                        WebMediaPlayer.this.webAPI.executeScript("%s.playbackRate = $rate;\n".formatted(WebMediaPlayer.this.playerVideoElement.getName()).replace("$rate", String.valueOf(rate)));
                    }
                }
            };
        }
        return this.rate;
    }

    @Override
    public double getCurrentRate() {
        return this.currentRate == null ? 0.0 : this.currentRate.get();
    }

    private void setCurrentRate(double value) {
        this.currentRatePropertyImpl().set(value);
    }

    @Override
    public ReadOnlyDoubleProperty currentRateProperty() {
        return this.currentRatePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper currentRatePropertyImpl() {
        if (this.currentRate == null) {
            this.currentRate = new ReadOnlyDoubleWrapper((Object)this, "currentRate");
        }
        return this.currentRate;
    }

    @Override
    public void play() {
        if (this.playerReady && this.getStatus() != MediaPlayer.Status.DISPOSED) {
            if (this.isEOS) {
                this.seek(this.getStartTime());
            }
            this.webAPI.executeScript("%s.play();\n".formatted(this.playerVideoElement.getName()));
        }
    }

    @Override
    public void pause() {
        if (this.playerReady && this.getStatus() != MediaPlayer.Status.DISPOSED) {
            this.webAPI.executeScript("%s.pause();\n".formatted(this.playerVideoElement.getName()));
        }
    }

    @Override
    public void stop() {
        if (this.playerReady && this.getStatus() != MediaPlayer.Status.DISPOSED) {
            this.webAPI.executeScript("%s.pause();\n".formatted(this.playerVideoElement.getName()));
            this.seek(this.getStartTime());
            this.setCurrentCount(0);
        }
        this.setStatus(MediaPlayer.Status.STOPPED);
    }

    @Override
    public void seek(Duration seekTime) {
        if (seekTime == null) {
            this.setError(new MediaPlayerException("Seek time is null."));
        } else if (this.playerReady) {
            double seekSeconds;
            if (this.getStatus() == MediaPlayer.Status.DISPOSED) {
                return;
            }
            if (seekTime.isUnknown()) {
                this.setError(new MediaPlayerException("Seek time is unknown."));
                return;
            }
            if (seekTime.lessThan(Duration.ZERO)) {
                this.setError(new MediaPlayerException("Seek time is negative. The value will be clamp to zero."));
                seekTime = Duration.ZERO;
            }
            if (seekTime.isIndefinite()) {
                Duration duration = this.getDuration();
                if (duration == null || duration.isUnknown() || duration.isIndefinite()) {
                    duration = Duration.millis((double)Double.MAX_VALUE);
                }
                seekSeconds = duration.toMillis() / 1000.0;
            } else {
                double[] startStop;
                seekSeconds = seekTime.toMillis() / 1000.0;
                if (seekSeconds < (startStop = this.calculateStartStopTimes(this.getStartTime(), this.getStopTime()))[0]) {
                    seekSeconds = startStop[0];
                } else if (seekSeconds > startStop[1]) {
                    seekSeconds = startStop[1];
                }
            }
            if ((this.getStatus() == MediaPlayer.Status.PLAYING || this.getStatus() == MediaPlayer.Status.PAUSED) && this.getStartTime().toSeconds() <= seekSeconds && seekSeconds <= this.getStopTime().toSeconds()) {
                this.isEOS = false;
            }
            this.webAPI.executeScript("%s.currentTime = %s;\n".formatted(this.playerVideoElement.getName(), seekSeconds));
        }
    }

    private void handleWebEvent(String eventName, String eventHandler, WebCallback webCallback) {
        this.webAPI.registerJavaFunction(this.mediaPlayerId + "_" + eventName, webCallback);
        this.webAPI.executeScript("let elem = $playerVideoElem;\nelem.on$eventName = (event) => {\n     $eventHandler\n};\n".replace("$playerVideoElem", this.playerVideoElement.getName()).replace("$eventHandler", eventHandler).replace("java_fun", "jpro.$mediaPlayerId_$eventName").replace("$mediaPlayerId", this.mediaPlayerId).replace("$eventName", eventName));
    }

    private double clamp(double min, double value, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private JSVariable createPlayerVideoElement(String videoElement) {
        this.webAPI.executeScript("$playerVideoElem = document.createElement(\"video\");\n$playerVideoElem.controls = false;\n$playerVideoElem.muted = false;\n$playerVideoElem.setAttribute(\"webkit-playsinline\", 'webkit-playsinline');\n$playerVideoElem.setAttribute(\"playsinline\", 'playsinline');\n$playerVideoElem.style.transform = \"translate(-50%, -50%)\";\n$playerVideoElem.style.position = \"absolute\";\n$playerVideoElem.style.top = \"50%\";\n$playerVideoElem.style.left = \"50%\";\n".replace("$playerVideoElem", videoElement));
        return new JSVariable(this.webAPI, videoElement);
    }

    private void setStartStopTimes(Duration startValue, boolean isStartValueSet, Duration stopValue, boolean isStopValueSet) {
        if (this.getDuration().isIndefinite()) {
            return;
        }
        double[] startStopTimes = this.calculateStartStopTimes(startValue, stopValue);
        if (isStartValueSet) {
            Duration startTime = Duration.seconds((double)startStopTimes[0]);
            if ((this.getStatus() == MediaPlayer.Status.READY || this.getStatus() == MediaPlayer.Status.PAUSED) && startTime.greaterThan(this.getCurrentTime())) {
                this.setCurrentTime(startTime);
                this.seek(startTime);
            }
        }
        if (isStopValueSet) {
            Duration stopTime = Duration.seconds((double)startStopTimes[1]);
            if ((this.getStatus() == MediaPlayer.Status.READY || this.getStatus() == MediaPlayer.Status.PAUSED) && stopTime.lessThan(this.getCurrentTime())) {
                this.setCurrentTime(stopTime);
                this.seek(stopTime);
            }
        }
    }

    private double[] calculateStartStopTimes(Duration startValue, Duration stopValue) {
        double actualStop;
        double newStart = startValue == null || startValue.lessThan(Duration.ZERO) || startValue.equals((Object)Duration.UNKNOWN) ? 0.0 : (startValue.equals((Object)Duration.INDEFINITE) ? Double.MAX_VALUE : startValue.toMillis() / 1000.0);
        double newStop = stopValue == null || stopValue.equals((Object)Duration.UNKNOWN) || stopValue.equals((Object)Duration.INDEFINITE) ? Double.MAX_VALUE : (stopValue.lessThan(Duration.ZERO) ? 0.0 : stopValue.toMillis() / 1000.0);
        Duration mediaDuration = this.getDuration();
        double duration = mediaDuration == Duration.UNKNOWN ? Double.MAX_VALUE : mediaDuration.toMillis() / 1000.0;
        double actualStart = this.clamp(newStart, 0.0, duration);
        if (actualStart > (actualStop = this.clamp(newStop, 0.0, duration))) {
            actualStop = actualStart;
        }
        return new double[]{actualStart, actualStop};
    }

    private void calculateCycleDuration() {
        Duration mediaDuration = this.getDuration();
        Duration endTime = !this.getStopTime().isUnknown() ? this.getStopTime() : mediaDuration;
        if (endTime.greaterThan(mediaDuration)) {
            endTime = mediaDuration;
        }
        if ((endTime.isUnknown() || this.getStartTime().isUnknown() || this.getStartTime().isIndefinite()) && !this.getCycleDuration().isUnknown()) {
            this.setCycleDuration(Duration.UNKNOWN);
        }
        this.setCycleDuration(endTime.subtract(this.getStartTime()));
        this.calculateTotalDuration();
    }

    private void calculateTotalDuration() {
        if (this.getCycleCount() == -1) {
            this.setTotalDuration(Duration.INDEFINITE);
        } else if (this.getCycleDuration().isUnknown()) {
            this.setTotalDuration(Duration.UNKNOWN);
        } else {
            this.setTotalDuration(this.getCycleDuration().multiply((double)this.getCycleCount()));
        }
    }

    private void handleRequestedChanges() {
        if (this.startTimeChangeRequested || this.stopTimeChangeRequested) {
            this.setStartStopTimes(this.getStartTime(), this.startTimeChangeRequested, this.getStopTime(), this.stopTimeChangeRequested);
            this.stopTimeChangeRequested = false;
            this.startTimeChangeRequested = false;
        }
    }
}

