/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.media.recorder.impl;

import com.jpro.webapi.JSVariable;
import com.jpro.webapi.WebAPI;
import java.util.Objects;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.event.Event;
import javafx.event.EventTarget;
import one.jpro.platform.media.MediaSource;
import one.jpro.platform.media.WebMediaEngine;
import one.jpro.platform.media.event.MediaRecorderEvent;
import one.jpro.platform.media.recorder.MediaRecorder;
import one.jpro.platform.media.recorder.MediaRecorderException;
import one.jpro.platform.media.recorder.impl.BaseMediaRecorder;
import one.jpro.platform.media.recorder.impl.MediaRecorderOptions;
import org.json.JSONObject;

public final class WebMediaRecorder
extends BaseMediaRecorder
implements WebMediaEngine {
    private static final String DEFAULT_MIME_TYPE = "video/webm";
    private final WebAPI webAPI;
    private final String mediaRecorderRef;
    private final String blobsRecordedRef;
    private final JSVariable recorderVideoElement;
    private ReadOnlyStringWrapper mimeType;

    public WebMediaRecorder(WebAPI webAPI) {
        this.webAPI = Objects.requireNonNull(webAPI, "WebAPI must not be null.");
        String recorderId = webAPI.createUniqueJSName("recorder_");
        this.mediaRecorderRef = "media_" + recorderId;
        this.blobsRecordedRef = "blobs_" + recorderId;
        this.recorderVideoElement = this.createRecorderVideoElement("video_elem_" + recorderId);
        webAPI.registerJavaFunction(this.mediaRecorderRef + "_ready", result -> {
            this.recorderReady = true;
            this.setStatus(MediaRecorder.Status.READY);
            Event.fireEvent((EventTarget)this, (Event)new MediaRecorderEvent(this, MediaRecorderEvent.MEDIA_RECORDER_READY));
        });
        webAPI.registerJavaFunction(this.mediaRecorderRef + "_onstart", result -> {
            MediaRecorder.Status.fromJS(result).ifPresent(this::setStatus);
            Event.fireEvent((EventTarget)this, (Event)new MediaRecorderEvent(this, MediaRecorderEvent.MEDIA_RECORDER_START));
        });
        webAPI.registerJavaFunction(this.mediaRecorderRef + "_onpause", result -> {
            MediaRecorder.Status.fromJS(result).ifPresent(this::setStatus);
            Event.fireEvent((EventTarget)this, (Event)new MediaRecorderEvent(this, MediaRecorderEvent.MEDIA_RECORDER_PAUSE));
        });
        webAPI.registerJavaFunction(this.mediaRecorderRef + "_onresume", result -> {
            MediaRecorder.Status.fromJS(result).ifPresent(this::setStatus);
            Event.fireEvent((EventTarget)this, (Event)new MediaRecorderEvent(this, MediaRecorderEvent.MEDIA_RECORDER_RESUME));
        });
        webAPI.registerJavaFunction(this.mediaRecorderRef + "_onstop", result -> {
            JSONObject json = new JSONObject(result.substring(1, result.length() - 1).replace("\\", ""));
            String objectUrl = json.getString("objectUrl");
            long fileSize = json.getLong("fileSize");
            this.setMediaSource(new MediaSource(webAPI.createJSFile(objectUrl, "RecordedVideo", fileSize)));
            this.setStatus(MediaRecorder.Status.INACTIVE);
            Event.fireEvent((EventTarget)this, (Event)new MediaRecorderEvent(this, MediaRecorderEvent.MEDIA_RECORDER_STOP));
        });
        webAPI.registerJavaFunction(this.mediaRecorderRef + "_ondataavailable", result -> Event.fireEvent((EventTarget)this, (Event)new MediaRecorderEvent(this, MediaRecorderEvent.MEDIA_RECORDER_DATA_AVAILABLE)));
        webAPI.registerJavaFunction(this.mediaRecorderRef + "_onerror", result -> {
            this.setStatus(MediaRecorder.Status.INACTIVE);
            this.setError(MediaRecorderException.fromJSON(result));
        });
    }

    @Override
    public WebAPI getWebAPI() {
        return this.webAPI;
    }

    @Override
    public JSVariable getVideoElement() {
        return this.recorderVideoElement;
    }

    public boolean isTypeSupported(String mimeType) throws Exception {
        return Boolean.getBoolean(this.webAPI.executeScriptWithReturn("MediaRecorder.isTypeSupported(\"%s\")\n".formatted(mimeType)));
    }

    public String getMimeType() {
        return this.mimeType == null ? DEFAULT_MIME_TYPE : this.mimeType.get();
    }

    private void setMimeType(String value) {
        this.mimeTypePropertyImpl().set(value);
    }

    public ReadOnlyStringProperty mimeTypeProperty() {
        return this.mimeTypePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyStringWrapper mimeTypePropertyImpl() {
        if (this.mimeType == null) {
            this.mimeType = new ReadOnlyStringWrapper((Object)this, "mimeType", DEFAULT_MIME_TYPE);
        }
        return this.mimeType;
    }

    @Override
    public void enable() {
        MediaRecorderOptions mediaRecorderOptions = new MediaRecorderOptions().mimeType(this.getMimeType());
        this.webAPI.executeScript("$blobsRecorded = []; // stream buffer\nnavigator.mediaDevices.getUserMedia({ video: true, audio: true })\n    .then((stream) => {\n        $recorderVideoElem.srcObject = stream;\n        $mediaRecorder = new MediaRecorder($recorderVideoElem.srcObject, $videoRecorderOptions);\n\n        // recorder is ready\n        jpro.$mediaRecorder_ready();\n\n        // event : new recorded video blob available\n        $mediaRecorder.addEventListener('dataavailable', function(e) {\n            $blobsRecorded.push(e.data);\n            jpro.$mediaRecorder_ondataavailable(e.timecode);\n        });\n\n        // event : recording stopped & all blobs sent\n        $mediaRecorder.onstop = (event) => {\n            // create local object URL from the recorded video blobs\n            let recordedBlob = new Blob($blobsRecorded, { type: \"video/webm\" });\n            let videoUrl = URL.createObjectURL(recordedBlob);\n            // pas object url and file size as json format\n            jpro.$mediaRecorder_onstop(JSON.stringify({\n                objectUrl: videoUrl,\n                fileSize: recordedBlob.size\n            }));\n        }\n\n        $mediaRecorder.onerror = (event) => {\n            // pas error type and message as json format\n            jpro.$mediaRecorder_onerror(JSON.stringify({\n                type: event.error.code,\n                message: event.error.message\n            }));\n        }\n\n        $mediaRecorder.onstart = (event) => jpro.$mediaRecorder_onstart($mediaRecorder.state)\n        $mediaRecorder.onpause = (event) => jpro.$mediaRecorder_onpause($mediaRecorder.state)\n        $mediaRecorder.onresume = (event) => jpro.$mediaRecorder_onresume($mediaRecorder.state)\n    });\n".replace("$recorderVideoElem", this.recorderVideoElement.getName()).replace("$videoRecorderOptions", mediaRecorderOptions.toJSON().toString()).replace("$blobsRecorded", this.blobsRecordedRef).replace("$mediaRecorder", this.mediaRecorderRef));
    }

    @Override
    public void start() {
        if (this.recorderReady) {
            if (this.getStatus().equals((Object)MediaRecorder.Status.INACTIVE) || this.getStatus().equals((Object)MediaRecorder.Status.READY)) {
                this.webAPI.executeScript("$blobsRecorded = []; // clear recorded buffer\n$mediaRecorder.start(1000); // start recording with a timeslice of 1 second\n".replace("$blobsRecorded", this.blobsRecordedRef).replace("$mediaRecorder", this.mediaRecorderRef));
            } else if (this.getStatus().equals((Object)MediaRecorder.Status.PAUSED)) {
                this.webAPI.executeScript("if ($mediaRecorder.state === \"paused\") {\n    $mediaRecorder.resume();\n}\n".replace("$mediaRecorder", this.mediaRecorderRef));
            }
        }
    }

    @Override
    public void pause() {
        if (this.recorderReady) {
            this.webAPI.executeScript("if ($mediaRecorder.state === \"recording\") {\n    $mediaRecorder.pause();\n}\n".replace("$mediaRecorder", this.mediaRecorderRef));
        }
    }

    @Override
    public void stop() {
        if (this.recorderReady) {
            this.webAPI.executeScript("$mediaRecorder.stop();\n".replace("$mediaRecorder", this.mediaRecorderRef));
        }
    }

    private JSVariable createRecorderVideoElement(String recorderVideoElem) {
        this.webAPI.executeScript("$recorderVideoElem = document.createElement(\"video\");\n$recorderVideoElem.controls = false;\n$recorderVideoElem.autoplay = true;\n$recorderVideoElem.muted = true;\n$recorderVideoElem.setAttribute(\"webkit-playsinline\", 'webkit-playsinline');\n$recorderVideoElem.setAttribute(\"playsinline\", 'playsinline');\n".replace("$recorderVideoElem", recorderVideoElem));
        return new JSVariable(this.webAPI, recorderVideoElem);
    }
}

