/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.routing;

import com.jpro.webapi.WebAPI;
import java.io.Serializable;
import java.net.URI;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import one.jpro.platform.internal.openlink.OpenLink;
import one.jpro.platform.routing.LinkUtil$LinkDesktop$;
import one.jpro.platform.routing.LinkUtil$LinkJPro$;
import one.jpro.platform.routing.SessionManagerContext$;
import one.jpro.platform.routing.sessionmanager.SessionManager;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxedUnit;
import simplefx.all$;

public final class LinkUtil$ {
    public static LinkUtil$ MODULE$;
    private Function1<String, BoxedUnit> one$jpro$platform$routing$LinkUtil$$openLinkExternalFun;

    static {
        new LinkUtil$();
    }

    public Function1<String, BoxedUnit> one$jpro$platform$routing$LinkUtil$$openLinkExternalFun() {
        return this.one$jpro$platform$routing$LinkUtil$$openLinkExternalFun;
    }

    private void one$jpro$platform$routing$LinkUtil$$openLinkExternalFun_$eq(Function1<String, BoxedUnit> x$1) {
        this.one$jpro$platform$routing$LinkUtil$$openLinkExternalFun = x$1;
    }

    public void setOpenLinkExternalFun(Function1<String, BoxedUnit> x) {
        this.one$jpro$platform$routing$LinkUtil$$openLinkExternalFun_$eq(x);
    }

    public boolean isValidLink(String x) {
        boolean bl;
        try {
            URI uri = new URI(x);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public SessionManager getSessionManager(Node node) {
        return (SessionManager)SessionManagerContext$.MODULE$.getContext(node);
    }

    public void setLink(Node node, String url) {
        this.setLink(node, url, (Option<String>)None$.MODULE$, this.setLink$default$4());
    }

    public void setLink(Node node, String url, String text) {
        this.setLink(node, url, (Option<String>)new Some((Object)text), this.setLink$default$4());
    }

    public void setLink(Node node, String url, Option<String> text, boolean external) {
        String string = url;
        String string2 = "";
        Predef$.MODULE$.assert(string == null ? string2 != null : !string.equals(string2), (Function0 & Serializable & scala.Serializable)() -> "Empty link: ''");
        Predef$.MODULE$.assert(this.isValidLink(url), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Invalid link: '").append(url).append("''").toString());
        node.getProperties().put((Object)"link", (Object)url);
        text.map((Function1 & Serializable & scala.Serializable)desc -> node.getProperties().put((Object)"description", desc));
        if (url == null || url.startsWith("/") || url.startsWith("./") || url.startsWith("../")) {
            this.setLinkInternalPush(node, url, text, external);
            return;
        }
        this.setLinkInternalNoPush(node, url, text, external);
    }

    public Option<String> setLink$default$3() {
        return None$.MODULE$;
    }

    public boolean setLink$default$4() {
        return false;
    }

    public void setExternalLink(Node node, String url) {
        this.setLink(node, url, (Option<String>)None$.MODULE$, true);
    }

    public void setExternalLink(Node node, String url, String text) {
        this.setLink(node, url, (Option<String>)Option$.MODULE$.apply((Object)text), true);
    }

    public void setLinkInternalPush(Node node, String url, Option<String> text, boolean external) {
        all$.MODULE$.toNodeExtension(node).cursor_$eq(Cursor.HAND);
        this.setLinkSimple(url, text, true, external, node);
    }

    public Option<String> setLinkInternalPush$default$3() {
        return None$.MODULE$;
    }

    public boolean setLinkInternalPush$default$4() {
        return false;
    }

    public void setLinkInternalNoPush(Node node, String url, Option<String> text, boolean external) {
        all$.MODULE$.toNodeExtension(node).cursor_$eq(Cursor.HAND);
        this.setLinkSimple(url, text, false, external, node);
    }

    public Option<String> setLinkInternalNoPush$default$3() {
        return None$.MODULE$;
    }

    public boolean setLinkInternalNoPush$default$4() {
        return false;
    }

    public void goBack(Node node) {
        ((SessionManager)SessionManagerContext$.MODULE$.getContext(node)).goBack();
    }

    public void goForward(Node node) {
        ((SessionManager)SessionManagerContext$.MODULE$.getContext(node)).goForward();
    }

    public void gotoPage(Node node, String url) {
        this.getSessionManager(node).gotoURL(url);
    }

    public void gotoPage(SessionManager sessionManager, String url) {
        sessionManager.gotoURL(url);
    }

    public String getCurrentPage(Node node) {
        return this.getSessionManager(node).url();
    }

    public void refresh(Node node) {
        SessionManager man = this.getSessionManager(node);
        Predef$.MODULE$.assert(man.url() != null, (Function0 & Serializable & scala.Serializable)() -> "current url was null");
        man.gotoURL(man.url(), false, true);
    }

    private void setLinkSimple(String url, Option<String> text, boolean pushState, boolean external, Node theNode) {
        if (url == null) {
            throw new NullPointerException("url was null");
        }
        Option<String> option = text;
        Some some = new Some(null);
        if (!(option != null ? !option.equals((Object)some) : some != null)) {
            throw new NullPointerException("text was provided but null");
        }
        if (!WebAPI.isBrowser()) {
            LinkUtil$LinkDesktop$.MODULE$.toExtendNodeWithLink(theNode).setNewLink(url, text, pushState, external);
            return;
        }
        LinkUtil$LinkJPro$.MODULE$.toExtendNodeWithLink(theNode).setNewLink(url, text, pushState, external);
    }

    public void setImageViewDescription(ImageView view, String description) {
        view.setAccessibleRoleDescription(description);
    }

    public static final /* synthetic */ void $anonfun$openLinkExternalFun$1(String link) {
        OpenLink.openURL((String)link);
    }

    private LinkUtil$() {
        MODULE$ = this;
        this.one$jpro$platform$routing$LinkUtil$$openLinkExternalFun = (Function1 & Serializable & scala.Serializable)link -> {
            LinkUtil$.$anonfun$openLinkExternalFun$1(link);
            return BoxedUnit.UNIT;
        };
    }
}

