/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.routing.popup;

import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import simplefx.experimental.parts.FXFuture;

public class PopupAPI {
    public static final Object POPUP_CONTEXT = new Object();

    public static void openPopup(Pane popupContext, Node popup) {
        Objects.requireNonNull(popupContext, "popupContext must not be null");
        popup.getProperties().put(POPUP_CONTEXT, (Object)popupContext);
        popupContext.getChildren().add((Object)popup);
    }

    public static void closePopup(Node popupNode) {
        Node popup = PopupAPI.getPopup(popupNode);
        Pane popupContext = PopupAPI.getPopupContext(popup);
        popupContext.getChildren().remove((Object)popup);
    }

    public static <T> FXFuture<T> showLoadingScreen(Pane popupContext, FXFuture<T> fxFuture) {
        Objects.requireNonNull(popupContext, "popupContext must not be null");
        ProgressIndicator indicator = new ProgressIndicator();
        indicator.setMaxWidth(100.0);
        indicator.setMaxHeight(100.0);
        StackPane popup = new StackPane(new Node[]{indicator});
        popup.setStyle("-fx-background-color: #00000066;");
        PopupAPI.openPopup(popupContext, (Node)popup);
        fxFuture.onComplete(v -> {
            indicator.setProgress(1.0);
            PopupAPI.closePopup((Node)popup);
        });
        return fxFuture;
    }

    public static Pane getPopupContext(Node popup) {
        Pane context = (Pane)popup.getProperties().get(POPUP_CONTEXT);
        return context == null ? PopupAPI.getPopupContext((Node)popup.getParent()) : context;
    }

    public static Node getPopup(Node popupNode) {
        Node context = (Node)popupNode.getProperties().get(POPUP_CONTEXT);
        return context == null ? PopupAPI.getPopup((Node)popupNode.getParent()) : popupNode;
    }
}

