/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.routing.popup;

import java.util.Optional;
import javafx.collections.ObservableMap;
import javafx.css.Styleable;
import javafx.scene.Node;

public class ContextManager<A> {
    private final Object CONTEXT_KEY = new Object();

    public void setContext(Node node, A context) {
        node.getProperties().put(this.CONTEXT_KEY, context);
    }

    public A getContext(Node node) {
        return this.findContext((Styleable)node).orElseThrow(() -> new IllegalStateException("Couldn't find context for node: " + String.valueOf(node)));
    }

    private Optional<A> findContext(Styleable styleable) {
        Node n;
        ObservableMap props;
        if (styleable instanceof Node && (props = (n = (Node)styleable).getProperties()).containsKey(this.CONTEXT_KEY)) {
            return Optional.of(props.get(this.CONTEXT_KEY));
        }
        Styleable parent = styleable.getStyleableParent();
        if (parent != null) {
            return this.findContext(parent);
        }
        return Optional.empty();
    }
}

