/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.routing.popup;

import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import one.jpro.platform.routing.Filter;
import one.jpro.platform.routing.Request;
import one.jpro.platform.routing.filter.container.Container;
import one.jpro.platform.routing.filter.container.ContainerFilter;
import one.jpro.platform.routing.popup.ContextManager;
import simplefx.experimental.parts.FXFuture;

public class PopupAPI {
    public static final ContextManager<Pane> POPUP_CONTAINER_CONTEXT = new ContextManager();
    public static final ContextManager<Node> POPUP_CONTEXT = new ContextManager();

    public static void registerPopupContainer(Pane container) {
        Objects.requireNonNull(container, "container must not be null");
        POPUP_CONTAINER_CONTEXT.setContext((Node)container, container);
    }

    public static void openPopup(Node contextHolder, Node popup) {
        Objects.requireNonNull(popup, "popup must not be null");
        Pane container = POPUP_CONTAINER_CONTEXT.getContext(contextHolder);
        POPUP_CONTEXT.setContext(popup, popup);
        POPUP_CONTAINER_CONTEXT.setContext(popup, container);
        container.getChildren().add((Object)popup);
    }

    public static void closePopup(Node anyNodeInPopup) {
        Node popup = POPUP_CONTEXT.getContext(anyNodeInPopup);
        Pane container = POPUP_CONTAINER_CONTEXT.getContext(popup);
        container.getChildren().remove((Object)popup);
    }

    public static <T> FXFuture<T> showLoadingScreen(Node contextHolder, FXFuture<T> fxFuture) {
        Objects.requireNonNull(contextHolder, "contextHolder must not be null");
        ProgressIndicator indicator = new ProgressIndicator();
        indicator.setMaxWidth(100.0);
        indicator.setMaxHeight(100.0);
        StackPane popup = new StackPane(new Node[]{indicator});
        popup.setStyle("-fx-background-color: #00000066;");
        PopupAPI.openPopup(contextHolder, (Node)popup);
        fxFuture.onComplete(v -> {
            indicator.setProgress(1.0);
            PopupAPI.closePopup((Node)popup);
        });
        return fxFuture;
    }

    public static Filter createPopupContainerFilter() {
        return ContainerFilter.create(() -> new PopupContainer(), PopupContainer.class);
    }

    private static class PopupContainer
    extends StackPane
    implements Container {
        private final ObjectProperty<Node> contentProperty = new SimpleObjectProperty((Object)this, "content");
        private final ObjectProperty<Request> requestProperty = new SimpleObjectProperty((Object)this, "request");

        public PopupContainer() {
            PopupAPI.registerPopupContainer((Pane)this);
            this.contentProperty.addListener((observable, oldValue, newValue) -> {
                if (oldValue != null) {
                    this.getChildren().remove(oldValue);
                }
                if (newValue != null) {
                    this.getChildren().add(newValue);
                }
            });
        }

        public ObjectProperty<Node> contentProperty() {
            return this.contentProperty;
        }

        public Node getContent() {
            return (Node)this.contentProperty.get();
        }

        public void setContent(Node content) {
            this.contentProperty.set((Object)content);
        }

        public ObjectProperty<Request> requestProperty() {
            return this.requestProperty;
        }

        public Request getRequest() {
            return (Request)this.requestProperty.get();
        }

        public void setRequest(Request request) {
            this.requestProperty.set((Object)request);
        }
    }
}

