/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.routing.popup.simplepopup;

import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import one.jpro.platform.routing.popup.PopupAPI;
import org.kordamp.ikonli.javafx.FontIcon;

public class SimplePopup
extends StackPane {
    public SimplePopup(String title, Node content, List<Button> buttons, boolean closable) {
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/one/jpro/platform/routing/popup/simplepopup/simplepopup.css").toExternalForm());
        this.getStyleClass().add((Object)"simple-popup-background");
        VBox popupBox = new VBox();
        this.getChildren().add((Object)popupBox);
        popupBox.setMaxWidth(Double.NEGATIVE_INFINITY);
        popupBox.setMaxHeight(Double.NEGATIVE_INFINITY);
        popupBox.getStyleClass().add((Object)"simple-popup-content");
        Node topArea = this.createTopArea(title, closable);
        popupBox.getChildren().add((Object)topArea);
        popupBox.getChildren().add((Object)this.createContentArea(content));
        Node buttonArea = this.createButtonArea(buttons);
        popupBox.getChildren().add((Object)buttonArea);
    }

    public Node createTopArea(String title, boolean closable) {
        StackPane topArea = new StackPane();
        topArea.getStyleClass().add((Object)"simple-popup-top-area");
        Label titleLabel = new Label(title);
        titleLabel.getStyleClass().add((Object)"simple-popup-title");
        topArea.getChildren().add((Object)titleLabel);
        if (closable) {
            Button closeButton = new Button();
            closeButton.getStyleClass().add((Object)"simple-popup-close-button");
            FontIcon closeIcon = new FontIcon("eva-close");
            closeButton.setGraphic((Node)closeIcon);
            StackPane.setAlignment((Node)closeButton, (Pos)Pos.CENTER_RIGHT);
            closeButton.setOnAction(e -> PopupAPI.closePopup((Node)this));
            topArea.getChildren().add((Object)closeButton);
        }
        return topArea;
    }

    public Node createContentArea(Node content) {
        StackPane contentArea = new StackPane();
        VBox.setVgrow((Node)contentArea, (Priority)Priority.ALWAYS);
        contentArea.getStyleClass().add((Object)"simple-popup-content-area");
        contentArea.getChildren().add((Object)content);
        return contentArea;
    }

    public Node createButtonArea(List<Button> buttons) {
        HBox buttonArea = new HBox();
        buttonArea.getStyleClass().add((Object)"simple-popup-button-area");
        buttonArea.getChildren().addAll(buttons);
        return buttonArea;
    }
}

