/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.scenegraph;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;

public class SceneGraphSerializer {
    private List<String> importantClasses = List.of("javafx.scene.layout.VBox", "javafx.scene.layout.HBox", "javafx.scene.layout.StackPane", "javafx.scene.layout.GridPane", "javafx.scene.control.ScrollPane");
    private List<String> finalClasses = List.of("javafx.scene.control.Label", "javafx.scene.control.Button");

    public static String serialize(Node node) {
        return new SceneGraphSerializer().serialize(node, 0);
    }

    private String serialize(Node node, int depth) {
        if (node == null) {
            return "";
        }
        Class<?> clazz = node.getClass();
        Class<?> layoutClass = this.getLayoutClass(clazz);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getIndent(depth));
        if (layoutClass != null && !layoutClass.equals(clazz)) {
            sb.append(clazz.getSimpleName());
            sb.append("(");
            sb.append(layoutClass.getSimpleName());
            sb.append(")");
        } else {
            sb.append(clazz.getSimpleName());
        }
        sb.append(" ");
        StringBuilder sbBracket = new StringBuilder();
        String id = node.getId();
        if (id != null && !id.isEmpty()) {
            sbBracket.append("id=");
            sbBracket.append(id);
        }
        for (String styleClass : node.getStyleClass()) {
            if (sbBracket.length() > 0) {
                sbBracket.append(", ");
            }
            sbBracket.append(styleClass);
        }
        if (sbBracket.length() > 0) {
            sb.append("[");
            sb.append((CharSequence)sbBracket);
            sb.append("]");
        }
        sb.append("\n");
        if (!this.isFinalClass(clazz) && node instanceof Parent) {
            for (Node child : ((Parent)node).getChildrenUnmodifiable()) {
                sb.append(this.serialize(child, depth + 1));
            }
        }
        return sb.toString();
    }

    private String getIndent(int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("- ");
        }
        return sb.toString();
    }

    private Class<?> getLayoutClass(Class<?> obj) {
        if (obj == null) {
            return null;
        }
        if (this.importantClasses.contains(obj.getName())) {
            return obj;
        }
        return this.getLayoutClass(obj.getSuperclass());
    }

    private boolean isFinalClass(Class<?> obj) {
        if (obj == null) {
            return false;
        }
        if (this.finalClasses.contains(obj.getName())) {
            return true;
        }
        return this.isFinalClass(obj.getSuperclass());
    }
}

