/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.session;

import com.jpro.webapi.WebAPI;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.WeakHashMap;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import one.jpro.platform.session.SessionException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger logger = LoggerFactory.getLogger((String)SessionManager.class.getName());
    private final File baseDirectory;
    private final String cookieName;
    private static final Random random = new Random();
    private final WeakHashMap<String, ObservableMap<String, String>> sessionCache = new WeakHashMap();

    public SessionManager(String appName) {
        this(new File(new File(System.getProperty("user.home")), "." + appName).getAbsoluteFile(), "c-" + appName);
    }

    public SessionManager(File baseDirectory, String cookieName) {
        this.baseDirectory = baseDirectory;
        this.cookieName = cookieName;
        if (!baseDirectory.exists()) {
            if (baseDirectory.mkdir()) {
                logger.info("Created session directory: " + String.valueOf(baseDirectory));
            } else {
                throw new SessionException("Could not create session directory: " + String.valueOf(baseDirectory));
            }
        }
    }

    public File getFolder() {
        return this.baseDirectory;
    }

    public ObservableMap<String, String> getSession(WebAPI webAPI) {
        String cookieValue = (String)webAPI.getCookies().get((Object)this.cookieName);
        if (cookieValue == null || !this.isValidCookie(cookieValue).booleanValue()) {
            cookieValue = null;
        } else {
            File sessionDirectory = new File(this.baseDirectory, cookieValue);
            if (!sessionDirectory.exists()) {
                cookieValue = null;
            }
        }
        if (cookieValue == null) {
            cookieValue = this.createUniqueIdentifier();
            webAPI.setCookie(this.cookieName, cookieValue);
        }
        return this.getSession(cookieValue);
    }

    public ObservableMap<String, String> getSession(String sessionKey) {
        if (!Platform.isFxApplicationThread()) {
            throw new SessionException("Please use the JFX Application Thread!");
        }
        return this.getSessionCached(sessionKey);
    }

    private ObservableMap<String, String> getSessionCached(String sessionKey) {
        ObservableMap<String, String> res = this.sessionCache.get(sessionKey);
        if (res != null) {
            return res;
        }
        res = this.getSessionImpl(sessionKey);
        this.sessionCache.put(sessionKey, res);
        return res;
    }

    private ObservableMap<String, String> getSessionImpl(String sessionKey) {
        ObservableMap session = FXCollections.observableHashMap();
        if (!this.baseDirectory.exists()) {
            throw new SessionException("Internal Error: session directory does not exist: " + String.valueOf(this.baseDirectory));
        }
        File cookieDirectory = new File(this.baseDirectory, sessionKey);
        if (!cookieDirectory.exists()) {
            if (cookieDirectory.mkdir()) {
                logger.info("Created session directory: " + String.valueOf(cookieDirectory));
            } else {
                throw new SessionException("Could not create session directory: " + String.valueOf(cookieDirectory));
            }
        }
        try {
            for (File file : cookieDirectory.listFiles()) {
                String key = file.getName();
                String str = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                session.put((Object)key, (Object)str);
            }
        }
        catch (IOException ex) {
            throw new SessionException(ex);
        }
        session.addListener(change -> {
            String k = (String)change.getKey();
            File f = new File(cookieDirectory, k);
            if (change.wasRemoved() && !f.delete()) {
                logger.warn("Could not delete file: " + String.valueOf(f));
            }
            if (change.wasAdded()) {
                try {
                    logger.warn("Saving to: " + String.valueOf(f));
                    FileUtils.writeStringToFile((File)f, (String)((String)change.getValueAdded()), (Charset)StandardCharsets.UTF_8);
                    if (!f.exists()) {
                        throw new SessionException("Internal Error: file was not written: " + String.valueOf(f));
                    }
                }
                catch (Exception ex) {
                    logger.error("Error writing session content: " + String.valueOf(f));
                }
            }
        });
        return session;
    }

    private Boolean isValidCookie(String cookieValue) {
        try {
            return Integer.parseInt(cookieValue) >= 0;
        }
        catch (NumberFormatException ex) {
            logger.error("Unexpected cookie format: " + cookieValue);
            return false;
        }
    }

    private String createUniqueIdentifier() {
        String newValue;
        while (new File(this.baseDirectory, newValue = SessionManager.createIdentifier()).exists()) {
        }
        return newValue;
    }

    private static String createIdentifier() {
        return "" + random.nextInt(Integer.MAX_VALUE);
    }
}

