/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.sipjs.api.session;

import com.jpro.webapi.JSVariable;
import com.jpro.webapi.WebAPI;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import one.jpro.platform.webrtc.MediaStream;
import one.jpro.platform.webrtc.VideoFrame;

public class Session {
    WebAPI webapi;
    JSVariable session;
    StringProperty state;
    JSVariable jsFun;

    Session(JSVariable session, WebAPI webapi) {
        session.isPromise().thenAccept(v -> {
            if (v.booleanValue()) {
                new RuntimeException("JSVariable for Session is a promise").printStackTrace();
            }
        });
        this.session = session;
        this.webapi = webapi;
        this.state = new SimpleStringProperty("Initial");
        this.jsFun = webapi.registerJavaFunction(str -> {
            str = str.substring(1, str.length() - 1);
            this.state.set((Object)str);
        });
        webapi.js().eval(session.getName() + ".stateChange.addListener(" + this.jsFun.getName() + ");");
    }

    public StringProperty stateProperty() {
        return this.state;
    }

    public JSVariable getLocalStream() {
        return this.webapi.js().eval(this.session.getName() + ".sessionDescriptionHandler.localMediaStream");
    }

    public JSVariable getRemoteStream() {
        return this.webapi.js().eval(this.session.getName() + ".sessionDescriptionHandler.remoteMediaStream");
    }

    public void setupRemoteMedia(VideoFrame frame) {
        this.webapi.js().eval("const remoteStream = new MediaStream();\n" + this.session.getName() + ".sessionDescriptionHandler.peerConnection.getReceivers().forEach((receiver) => {\n  if (receiver.track) {\n    remoteStream.addTrack(receiver.track);\n  }\n});\n" + frame.getVideoElem().getName() + ".srcObject = remoteStream;\n" + frame.getVideoElem().getName() + ".play();");
    }

    public void switchToStream(MediaStream stream) {
        stream.js.thenAccept(js -> this.webapi.js().eval("var videoTrack = " + js.getName() + ".getVideoTracks()[0];\nvar sender = " + this.session.getName() + ".sessionDescriptionHandler.peerConnection.getSenders().find(function(s) {\n  return s.track.kind == videoTrack.kind;\n});\nconsole.log('found sender:', sender);\nsender.replaceTrack(videoTrack);"));
    }

    public void bye() {
        this.webapi.js().eval(this.session.getName() + ".bye();").toPromise().onPromiseError(e -> e.printStackTrace());
    }

    public void endCall() {
        this.webapi.js().eval("switch(" + this.session.getName() + ".state) {\n    case SessionState.Initial:\n    case SessionState.Establishing:\n      if (" + this.session.getName() + " instanceOf Inviter) {\n        // An unestablished outgoing session\n        " + this.session.getName() + ".cancel();\n      } else {\n        // An unestablished incoming session\n        " + this.session.getName() + ".reject();\n      }\n      break;\n    case SessionState.Established:\n      // An established session\n      " + this.session.getName() + ".bye();\n      break;\n    case SessionState.Terminating:\n    case SessionState.Terminated:\n      // Cannot terminate a session that is already terminated\n      break;\n  }");
    }

    public class State {
        public static final String Initial = "Initial";
        public static final String Establishing = "Establishing";
        public static final String Established = "Established";
        public static final String Terminating = "Terminating";
        public static final String Terminated = "Terminated";
    }
}

