/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.sipjs.api;

import com.jpro.webapi.JSVariable;
import com.jpro.webapi.PromiseJSVariable;
import com.jpro.webapi.WebAPI;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import one.jpro.platform.sipjs.SipJSUtil;
import one.jpro.platform.sipjs.api.options.InviterOptions;
import one.jpro.platform.sipjs.api.options.UserAgentOptions;
import one.jpro.platform.sipjs.api.session.Invitation;
import one.jpro.platform.sipjs.api.session.Inviter;

public class UserAgent {
    WebAPI webapi;
    JSVariable jsUserAgent;
    JSVariable jsRegistrator;
    JSVariable startPromise;
    PromiseJSVariable registerPromise;
    UserAgentOptions options;
    Consumer<Invitation> onInvite;
    private JSVariable onInviteJS;

    public UserAgent(UserAgentOptions options, WebAPI webapi) {
        this.webapi = webapi;
        this.options = options;
        SipJSUtil.loadSipJS(webapi);
        JSVariable optionsVariable = options.asJSVariable(webapi);
        this.onInviteJS = webapi.registerJavaFunctionWithVariable(invite -> {
            Invitation inventation = new Invitation((JSVariable)invite, webapi);
            this.onInvite.accept(inventation);
        });
        webapi.js().eval(optionsVariable.getName() + ".delegate = { onInvite: " + this.onInviteJS.getName() + " };");
        this.jsUserAgent = webapi.js().eval("new SIP.UserAgent(" + optionsVariable.getName() + ");");
        this.jsRegistrator = webapi.js().eval("new SIP.Registerer(" + this.jsUserAgent.getName() + ");");
        this.startPromise = webapi.js().eval(this.jsUserAgent.getName() + ".start();");
        this.registerPromise = webapi.js().evalAsync(this.startPromise.getName() + ".then(() => { " + this.jsRegistrator.getName() + ".register(); });");
    }

    public CompletableFuture<Inviter> makeCall(String target, InviterOptions options) {
        return JSVariable.promiseToFuture((WebAPI)this.webapi, (JSVariable)this.startPromise).thenApply(v -> {
            JSVariable jsTarget = this.webapi.js().eval("SIP.UserAgent.makeURI(\"" + target + "\");");
            JSVariable jsInviter = this.webapi.js().eval("new SIP.Inviter(" + this.jsUserAgent.getName() + ", " + jsTarget.getName() + ");");
            this.webapi.js().eval(jsInviter.getName() + ".invite(" + options.asJSVariable(this.webapi).getName() + ");");
            return new Inviter(jsInviter, this.webapi);
        });
    }

    public void setOnInvite(Consumer<Invitation> onInvite) {
        this.onInvite = onInvite;
    }

    public PromiseJSVariable getRegisterPromise() {
        return this.registerPromise;
    }
}

