/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.utils;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import one.jpro.platform.utils.PlatformUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface OpenLink {
    public static final Logger logger = LoggerFactory.getLogger(OpenLink.class);

    public static void openURL(@NotNull URL url) {
        Objects.requireNonNull(url, "URL cannot be null.");
        OpenLink.openURL(url.toString());
    }

    public static void openURL(@NotNull String url) {
        Objects.requireNonNull(url, "URL cannot be null.");
        if (PlatformUtils.isDesktop()) {
            try {
                List<String> command = PlatformUtils.isMac() ? List.of("open", url) : (PlatformUtils.isWindows() ? List.of("rundll32", "url.dll,FileProtocolHandler", url) : List.of("xdg-open", url));
                logger.debug("Opening URL with command {}", command);
                Runtime.getRuntime().exec((String[])command.toArray(String[]::new));
            }
            catch (IOException ex) {
                throw new UnsupportedOperationException("Unable to open the browser.", ex);
            }
        } else {
            throw new UnsupportedOperationException("Platform not supported.");
        }
    }
}

