/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.utils;

import com.jpro.webapi.JSVariable;
import com.jpro.webapi.WebAPI;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.Node;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)CopyUtil.class.getName());
    private static final Object COPY_HANDLER_KEY = new Object();

    public static void setCopyOnClick(Node node, String text) {
        CopyHandler handler = (CopyHandler)node.getProperties().get(COPY_HANDLER_KEY);
        if (handler == null) {
            handler = WebAPI.isBrowser() ? new CopyJPro(text, node) : new CopyDesktop(text, node);
            node.getProperties().put(COPY_HANDLER_KEY, (Object)handler);
        } else {
            handler.setText(text);
        }
        logger.debug("setCopyOnClick: " + String.valueOf(node) + ", " + text);
    }

    private static interface CopyHandler {
        public void setText(String var1);
    }

    private static class CopyJPro
    implements CopyHandler {
        private final SimpleStringProperty copyTextProperty = new SimpleStringProperty();

        public CopyJPro(String text, Node node) {
            this.setText(text);
            this.install(node);
        }

        @Override
        public void setText(String text) {
            this.copyTextProperty.set(text);
        }

        private void install(Node node) {
            WebAPI.getWebAPI((Node)node, webapi -> {
                JSVariable jsElem = webapi.getElement(node);
                Runnable run = () -> {
                    String origText = this.copyTextProperty.get();
                    if (origText == null) {
                        String string = jsElem.getName() + ".onmousedown = undefined;";
                    } else {
                        String escapedText = this.copyTextProperty.get().replace("'", "\\'").replace("\"", "\\\"").replace("\r\n", "\\n").replace("\r", "\\n").replace("\n", "\\n");
                        String script = jsElem.getName() + ".onmousedown = function(event) {  navigator.clipboard.writeText('" + escapedText + "');};";
                        webapi.executeScript(script);
                    }
                };
                this.copyTextProperty.addListener((observable, oldValue, newValue) -> run.run());
                run.run();
            });
        }
    }

    private static class CopyDesktop
    implements CopyHandler {
        private String text;

        public CopyDesktop(String text, Node node) {
            this.text = text;
            this.install(node);
        }

        @Override
        public void setText(String text) {
            this.text = text;
        }

        private void install(Node node) {
            node.setOnMouseClicked(event -> {
                if (this.text != null) {
                    Clipboard clipboard = Clipboard.getSystemClipboard();
                    ClipboardContent content = new ClipboardContent();
                    content.putString(this.text);
                    clipboard.setContent((Map)content);
                }
            });
        }
    }
}

