/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.utils;

import com.jpro.webapi.WebAPI;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import one.jpro.platform.utils.PlatformUtils;

public class UserPlatform {
    private final String platform;
    private final WebAPI webAPI;
    private final boolean isNative;

    public UserPlatform(WebAPI webAPI) {
        this(UserPlatform.platformFrom(webAPI), webAPI, !WebAPI.isBrowser());
    }

    private UserPlatform(String platform, WebAPI webAPI, boolean isNative) {
        this.platform = platform;
        this.isNative = isNative;
        this.webAPI = webAPI;
    }

    public static UserPlatform simulateNative() {
        return new UserPlatform(System.getProperty("os.name"), null, true);
    }

    public static UserPlatform simulateNative(String s) {
        return new UserPlatform(s, null, true);
    }

    public static UserPlatform simulateWeb(String platform, String platformOld) {
        return new UserPlatform(UserPlatform.platformFrom(platform, platformOld), null, false);
    }

    private static String platformFrom(WebAPI webAPI) {
        if (WebAPI.isBrowser()) {
            return UserPlatform.platformFrom(webAPI.getPlatform(), webAPI.getPlatformOld());
        }
        return System.getProperty("os.name");
    }

    private static String platformFrom(String primary, String fallback) {
        if (primary != null && !primary.isEmpty()) {
            return primary;
        }
        return fallback != null ? fallback : "";
    }

    public boolean isWindows() {
        return this.platform.toLowerCase().contains("win");
    }

    public boolean isMac() {
        return this.platform.toLowerCase().contains("mac");
    }

    public boolean isLinux() {
        String lower = this.platform.toLowerCase();
        return lower.contains("nux") || lower.contains("linux");
    }

    public boolean isWeb() {
        return WebAPI.isBrowser();
    }

    public boolean isMobile() {
        if (this.isNative) {
            return PlatformUtils.isAndroid() || PlatformUtils.isIOS();
        }
        return this.webAPI.isMobile();
    }

    public KeyCode getModifierKey() {
        return this.isMac() ? KeyCode.META : KeyCode.CONTROL;
    }

    public KeyCombination.Modifier getModifierKeyCombination() {
        return this.isMac() ? KeyCombination.META_DOWN : KeyCombination.CONTROL_DOWN;
    }

    public static KeyCode getModifierKey(WebAPI webAPI) {
        return new UserPlatform(webAPI).getModifierKey();
    }

    public static KeyCombination.Modifier getModifierKeyCombination(WebAPI webAPI) {
        return new UserPlatform(webAPI).getModifierKeyCombination();
    }

    public static boolean isWindows(WebAPI webAPI) {
        return new UserPlatform(webAPI).isWindows();
    }

    public static boolean isMac(WebAPI webAPI) {
        return new UserPlatform(webAPI).isMac();
    }

    public static boolean isLinux(WebAPI webAPI) {
        return new UserPlatform(webAPI).isLinux();
    }

    public static boolean isWeb(WebAPI webAPI) {
        return WebAPI.isBrowser();
    }

    public static boolean isMobile(WebAPI webAPI) {
        return new UserPlatform(webAPI).isMobile();
    }
}

