/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.webrtc;

import javafx.beans.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import one.jpro.platform.webrtc.RTCPeerConnection;

public class RTCDetails
extends VBox {
    private RTCPeerConnection rtc;

    public RTCDetails(RTCPeerConnection rtc) {
        this.rtc = rtc;
        this.getChildren().add((Object)this.createLabel("connectionState", rtc.connectionState));
        this.getChildren().add((Object)this.createLabel("iceConnectionState", rtc.iceConnectionState));
        this.getChildren().add((Object)this.createLabel("iceGatheringState", rtc.iceGatheringState));
        this.getChildren().add((Object)this.createLabel("signalingState", rtc.signalingState));
        this.getChildren().add((Object)this.createSizeLabel("iceCandidates", rtc.iceCandidates));
        this.getChildren().add((Object)this.createSizeLabel("trackCount", rtc.tracks));
    }

    private Label createLabel(String name, StringProperty prop) {
        Label label = new Label();
        label.textProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{name, ": ", prop}));
        return label;
    }

    private <T> Label createSizeLabel(String name, ObservableList<T> list) {
        Label label = new Label();
        list.addListener(change -> {
            while (change.next()) {
                if (!change.wasAdded()) continue;
                label.setText(name + ": " + list.size());
            }
        });
        label.wrapTextProperty().setValue(Boolean.valueOf(true));
        return label;
    }
}

