/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.webrtc;

import com.jpro.webapi.HTMLView;
import com.jpro.webapi.JSVariable;
import com.jpro.webapi.WebAPI;
import one.jpro.platform.webrtc.MediaStream;

public class VideoFrame
extends HTMLView {
    private WebAPI webAPI;
    JSVariable elem;
    JSVariable videoElem;

    public VideoFrame(WebAPI webAPI) {
        super("<video autoplay playsinline ></video>");
        this.webAPI = webAPI;
        this.elem = webAPI.getHTMLViewElement((HTMLView)this);
        this.videoElem = webAPI.executeScriptWithVariable(this.elem.getName() + ".firstElementChild");
        this.setPrefSize(100.0, 100.0);
        this.widthProperty().addListener((observable, oldValue, newValue) -> webAPI.executeScript(this.videoElem.getName() + ".width = " + newValue.intValue() + ";"));
        this.heightProperty().addListener((observable, oldValue, newValue) -> webAPI.executeScript(this.videoElem.getName() + ".height = " + newValue.intValue() + ";"));
    }

    public JSVariable getVideoElem() {
        return this.videoElem;
    }

    public void setStream(MediaStream stream) {
        stream.js.thenAccept(s -> this.webAPI.executeScript(this.videoElem.getName() + ".srcObject = " + s.getName() + ";"));
    }

    public void setStream(JSVariable stream) {
        this.webAPI.executeScript(this.videoElem.getName() + ".srcObject = " + stream.getName() + ";");
    }
}

