/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.webrtc;

import com.jpro.webapi.JSVariable;
import com.jpro.webapi.WebAPI;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import one.jpro.platform.webrtc.MediaStream;

public class RTCPeerConnection {
    private static String defaultConf = "{ iceServers: [{ urls: 'stun:stun.l.google.com:19302' }] }";
    public StringProperty connectionState = new SimpleStringProperty("new");
    public StringProperty iceConnectionState = new SimpleStringProperty("new");
    public StringProperty iceGatheringState = new SimpleStringProperty("new");
    public StringProperty signalingState = new SimpleStringProperty("stable");
    private WebAPI webAPI;
    private Set<Object> hardReferences = new HashSet<Object>();
    public ObservableList<JSVariable> tracks = FXCollections.observableArrayList();
    public ObservableList<String> iceCandidates = FXCollections.observableArrayList();
    public Consumer<String> onNewIceCandidate = str -> {};
    public Runnable onnegotiationneeded = () -> {};
    JSVariable js;

    public RTCPeerConnection(WebAPI webAPI) {
        this(webAPI, defaultConf);
    }

    public RTCPeerConnection(WebAPI webAPI, String conf) {
        this.webAPI = webAPI;
        this.js = webAPI.executeScriptWithVariable("new RTCPeerConnection(" + conf + ");");
        this.listenToProperty("connectionState", arg_0 -> ((StringProperty)this.connectionState).set(arg_0));
        this.listenToProperty("iceConnectionState", arg_0 -> ((StringProperty)this.iceConnectionState).set(arg_0));
        this.listenToProperty("iceGatheringState", arg_0 -> ((StringProperty)this.iceGatheringState).set(arg_0));
        this.listenToProperty("signalingState", arg_0 -> ((StringProperty)this.signalingState).set(arg_0));
        this.listenToJS("track", event -> {
            JSVariable track = webAPI.executeScriptWithVariable(event.getName() + ".streams[0];");
            this.tracks.add((Object)track);
        });
        this.listenToJS("icecandidate", iceCandidate -> webAPI.executeScriptWithFuture(iceCandidate.getName() + ".candidate").thenAccept(str -> {
            this.iceCandidates.add(str);
            this.onNewIceCandidate.accept((String)str);
        }));
        this.listenToJS("negotiationneeded", e -> {
            System.out.println("negotiationneeded: " + e.getName());
            this.onnegotiationneeded.run();
        });
    }

    public WebAPI getWebAPI() {
        return this.webAPI;
    }

    public void listenToJS(String propName, Consumer<JSVariable> setter) {
        JSVariable jsFun = this.webAPI.registerJavaFunctionWithVariable(setter);
        this.webAPI.executeScript(this.js.getName() + ".on" + propName + " = function(str){ console.log('str: ' + str); " + jsFun.getName() + "(str);};");
        this.hardReferences.add(jsFun);
    }

    public void listenToProperty(String propName, Consumer<String> setter) {
        JSVariable jsFun = this.webAPI.registerJavaFunction(str -> {
            str = str.substring(1, str.length() - 1);
            setter.accept(str);
        });
        this.webAPI.executeScript(this.js.getName() + ".on" + propName + "change = function(str){" + jsFun.getName() + "(str);};" + jsFun.getName() + "(" + this.js.getName() + "." + propName + ");");
        this.hardReferences.add(jsFun);
    }

    public CompletableFuture<String> createOfferAndSetLocal() {
        return this.webAPI.executeJSAsync("const offer = await " + this.js.getName() + ".createOffer();await " + this.js.getName() + ".setLocalDescription(offer);return offer;").thenCompose(js -> this.webAPI.executeScriptWithFuture(js.getName()));
    }

    public CompletableFuture<String> createAnswerAndSetLocal() {
        return this.webAPI.executeJSAsync("const answer = await " + this.js.getName() + ".createAnswer();await " + this.js.getName() + ".setLocalDescription(answer);return answer;").thenCompose(js -> this.webAPI.executeScriptWithFuture(js.getName()));
    }

    public CompletableFuture<JSVariable> setLocalDescription(String sdp) {
        return this.webAPI.executeJSAsync("return await " + this.js.getName() + ".setLocalDescription(" + sdp + ");");
    }

    public CompletableFuture<JSVariable> setRemoteDescription(String sdp) {
        return this.webAPI.executeJSAsync("return await " + this.js.getName() + ".setRemoteDescription(new RTCSessionDescription(" + sdp + "));");
    }

    public CompletableFuture<String> addStream(JSVariable stream) {
        return this.webAPI.executeScriptWithFuture(stream.getName() + ".getTracks().forEach(function(track) {" + this.js.getName() + ".addTrack(track, " + stream.getName() + ");}); undefined;");
    }

    public CompletableFuture<JSVariable> removeStream(MediaStream stream) {
        return stream.js.thenApply(s -> this.webAPI.executeScriptWithVariable(this.js.getName() + ".getSenders().forEach(sender => {if (sender.track) {sender.track.stop();}" + this.js.getName() + ".removeTrack(sender);});"));
    }

    public void addTrack(JSVariable track) {
        this.webAPI.executeScript(this.js.getName() + ".addTrack(" + track.getName() + ");");
    }

    public void removeTracks(JSVariable stream) {
        this.webAPI.executeScript(this.js.getName() + ".removeTrack(" + stream.getName() + ");");
    }

    public void addIceCandidate(String iceCandidate) {
        if (iceCandidate == null) {
            throw new IllegalArgumentException("iceCandidate must not be null");
        }
        if (iceCandidate.equals("null")) {
            throw new IllegalArgumentException("iceCandidate was String 'null'");
        }
        this.webAPI.executeScript(this.js.getName() + ".addIceCandidate(new RTCIceCandidate(" + iceCandidate + "));");
    }

    public static void connectConnections(RTCPeerConnection rtc1, RTCPeerConnection rtc2) {
        rtc1.iceCandidates.stream().forEach(rtc2::addIceCandidate);
        rtc2.iceCandidates.stream().forEach(rtc1::addIceCandidate);
        rtc1.onNewIceCandidate = rtc2::addIceCandidate;
        rtc2.onNewIceCandidate = rtc1::addIceCandidate;
        AtomicBoolean isNegotiating = new AtomicBoolean(false);
        rtc1.onnegotiationneeded = () -> {
            if (!isNegotiating.get()) {
                isNegotiating.set(true);
                RTCPeerConnection.negotiate(rtc1, rtc2).thenRun(() -> isNegotiating.set(false));
            }
        };
        rtc2.onnegotiationneeded = () -> {
            if (!isNegotiating.get()) {
                isNegotiating.set(true);
                RTCPeerConnection.negotiate(rtc2, rtc1).thenRun(() -> isNegotiating.set(false));
            }
        };
        isNegotiating.set(true);
        RTCPeerConnection.negotiate(rtc1, rtc2).thenRun(() -> isNegotiating.set(false));
    }

    public static CompletableFuture<JSVariable> negotiate(RTCPeerConnection rtc1, RTCPeerConnection rtc2) {
        return rtc1.createOfferAndSetLocal().thenCompose(sdp -> rtc2.setRemoteDescription((String)sdp).thenCompose(s -> rtc2.createAnswerAndSetLocal().thenCompose(sdp2 -> rtc1.setRemoteDescription((String)sdp2))));
    }
}

