/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.youtube;

import com.jpro.webapi.HTMLView;
import com.jpro.webapi.JSVariable;
import com.jpro.webapi.WebAPI;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebView;

public class YoutubeNode
extends StackPane {
    protected int PREF_HEIGHT = 340;
    protected int PREF_WIDTH = 560;
    protected double ratio = 1.7777777777777777;

    public YoutubeNode(String videoId) {
        this.setPrefSize(-1.0, -1.0);
        this.setMinSize(-1.0, -1.0);
        this.setMaxSize(-1.0, -1.0);
        if (WebAPI.isBrowser()) {
            HTMLView htmlView = new HTMLView();
            htmlView.setContent("<iframe src=\"https://www.youtube.com/embed/" + videoId + "\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
            this.getChildren().add((Object)htmlView);
            WebAPI.getWebAPI((Node)this, webAPI -> {
                JSVariable elem = webAPI.getHTMLViewElement(htmlView);
                this.widthProperty().addListener((observable, oldValue, newValue) -> webAPI.executeScript(elem.getName() + ".firstElementChild.width = " + newValue.intValue() + ";"));
                this.heightProperty().addListener((observable, oldValue, newValue) -> webAPI.executeScript(elem.getName() + ".firstElementChild.height = " + newValue.intValue() + ";"));
                webAPI.executeScript(elem.getName() + ".firstElementChild.width = " + this.getWidth() + ";");
                webAPI.executeScript(elem.getName() + ".firstElementChild.height = " + this.getHeight() + ";");
            });
        } else {
            WebView webView = new WebView();
            webView.getEngine().load("https://www.youtube.com/embed/" + videoId);
            this.getChildren().add((Object)webView);
        }
    }

    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    protected double computePrefWidth(double height) {
        if (height <= -1.0) {
            return this.PREF_WIDTH;
        }
        return height * this.ratio;
    }

    protected double computePrefHeight(double width) {
        if (width <= -1.0) {
            return this.PREF_HEIGHT;
        }
        return width / this.ratio;
    }
}

