/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.treeshowing;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;

public class TreeShowing {
    private static final Object KEY_TREE_SHOWING = new Object();

    public static BooleanProperty treeShowing(Node node) {
        Object prop = (BooleanProperty)node.getProperties().get(KEY_TREE_SHOWING);
        if (prop == null) {
            prop = new TreeShowingProperty(node);
            node.getProperties().put(KEY_TREE_SHOWING, prop);
        }
        return prop;
    }

    public static boolean isTreeShowing(Node node) {
        return node.getScene() != null && node.getScene().getWindow() != null && node.getScene().getWindow().isShowing();
    }

    private static class TreeShowingProperty
    extends SimpleBooleanProperty {
        Scene scene = null;
        Window window = null;

        TreeShowingProperty(Node node) {
            super((Object)node, "treeVisible", false);
            Runnable updateValue = () -> {
                Scene myScene = node.getScene();
                this.set(myScene != null && myScene.getWindow() != null && myScene.getWindow().isShowing());
            };
            ChangeListener updateVisibleListener = (p, o, value) -> updateValue.run();
            ChangeListener updateWindowListener = (p, o, ignore) -> {
                Window changedWindow;
                Scene scene = node.getScene();
                Window window = changedWindow = scene == null ? null : scene.getWindow();
                if (this.window != null) {
                    this.window.showingProperty().removeListener(updateVisibleListener);
                }
                this.window = changedWindow;
                if (changedWindow != null) {
                    changedWindow.showingProperty().addListener(updateVisibleListener);
                    updateVisibleListener.changed(null, null, (Object)changedWindow.isShowing());
                } else {
                    updateValue.run();
                }
            };
            ChangeListener updateSceneListener = (p, o, ignore) -> {
                Scene changedScene = node.getScene();
                if (this.scene != null) {
                    this.scene.windowProperty().removeListener(updateWindowListener);
                }
                this.scene = changedScene;
                if (changedScene != null) {
                    changedScene.windowProperty().addListener(updateWindowListener);
                    updateWindowListener.changed(null, null, (Object)changedScene.getWindow());
                } else {
                    updateWindowListener.changed(null, null, null);
                    updateValue.run();
                }
            };
            node.sceneProperty().addListener(updateSceneListener);
            updateSceneListener.changed(null, null, (Object)node.getScene());
        }
    }
}

