/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.epubsquash.api;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import one.lfa.epubsquash.api.EPUBSquasherConfigurationType;

public final class EPUBSquasherConfiguration
implements EPUBSquasherConfigurationType {
    private final Path inputFile;
    private final Path temporaryDirectory;
    private final Path outputFile;
    private final double scale;
    private final double maximumImageWidth;
    private final double maximumImageHeight;

    private EPUBSquasherConfiguration(Builder builder) {
        this.inputFile = builder.inputFile;
        this.temporaryDirectory = builder.temporaryDirectory;
        this.outputFile = builder.outputFile;
        this.maximumImageWidth = builder.maximumImageWidth;
        this.maximumImageHeight = builder.maximumImageHeight;
        this.scale = builder.scaleIsSet() ? builder.scale : EPUBSquasherConfigurationType.super.scale();
    }

    private EPUBSquasherConfiguration(Path inputFile, Path temporaryDirectory, Path outputFile, double scale, double maximumImageWidth, double maximumImageHeight) {
        this.inputFile = inputFile;
        this.temporaryDirectory = temporaryDirectory;
        this.outputFile = outputFile;
        this.scale = scale;
        this.maximumImageWidth = maximumImageWidth;
        this.maximumImageHeight = maximumImageHeight;
    }

    @Override
    public Path inputFile() {
        return this.inputFile;
    }

    @Override
    public Path temporaryDirectory() {
        return this.temporaryDirectory;
    }

    @Override
    public Path outputFile() {
        return this.outputFile;
    }

    @Override
    public double scale() {
        return this.scale;
    }

    @Override
    public double maximumImageWidth() {
        return this.maximumImageWidth;
    }

    @Override
    public double maximumImageHeight() {
        return this.maximumImageHeight;
    }

    public final EPUBSquasherConfiguration withInputFile(Path value) {
        if (this.inputFile == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "inputFile");
        return new EPUBSquasherConfiguration(newValue, this.temporaryDirectory, this.outputFile, this.scale, this.maximumImageWidth, this.maximumImageHeight);
    }

    public final EPUBSquasherConfiguration withTemporaryDirectory(Path value) {
        if (this.temporaryDirectory == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "temporaryDirectory");
        return new EPUBSquasherConfiguration(this.inputFile, newValue, this.outputFile, this.scale, this.maximumImageWidth, this.maximumImageHeight);
    }

    public final EPUBSquasherConfiguration withOutputFile(Path value) {
        if (this.outputFile == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "outputFile");
        return new EPUBSquasherConfiguration(this.inputFile, this.temporaryDirectory, newValue, this.scale, this.maximumImageWidth, this.maximumImageHeight);
    }

    public final EPUBSquasherConfiguration withScale(double value) {
        if (Double.doubleToLongBits(this.scale) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new EPUBSquasherConfiguration(this.inputFile, this.temporaryDirectory, this.outputFile, value, this.maximumImageWidth, this.maximumImageHeight);
    }

    public final EPUBSquasherConfiguration withMaximumImageWidth(double value) {
        if (Double.doubleToLongBits(this.maximumImageWidth) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new EPUBSquasherConfiguration(this.inputFile, this.temporaryDirectory, this.outputFile, this.scale, value, this.maximumImageHeight);
    }

    public final EPUBSquasherConfiguration withMaximumImageHeight(double value) {
        if (Double.doubleToLongBits(this.maximumImageHeight) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new EPUBSquasherConfiguration(this.inputFile, this.temporaryDirectory, this.outputFile, this.scale, this.maximumImageWidth, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EPUBSquasherConfiguration && this.equalTo((EPUBSquasherConfiguration)another);
    }

    private boolean equalTo(EPUBSquasherConfiguration another) {
        return this.inputFile.equals(another.inputFile) && this.temporaryDirectory.equals(another.temporaryDirectory) && this.outputFile.equals(another.outputFile) && Double.doubleToLongBits(this.scale) == Double.doubleToLongBits(another.scale) && Double.doubleToLongBits(this.maximumImageWidth) == Double.doubleToLongBits(another.maximumImageWidth) && Double.doubleToLongBits(this.maximumImageHeight) == Double.doubleToLongBits(another.maximumImageHeight);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.inputFile.hashCode();
        h += (h << 5) + this.temporaryDirectory.hashCode();
        h += (h << 5) + this.outputFile.hashCode();
        h += (h << 5) + Double.hashCode(this.scale);
        h += (h << 5) + Double.hashCode(this.maximumImageWidth);
        h += (h << 5) + Double.hashCode(this.maximumImageHeight);
        return h;
    }

    public String toString() {
        return "EPUBSquasherConfiguration{inputFile=" + this.inputFile + ", temporaryDirectory=" + this.temporaryDirectory + ", outputFile=" + this.outputFile + ", scale=" + this.scale + ", maximumImageWidth=" + this.maximumImageWidth + ", maximumImageHeight=" + this.maximumImageHeight + "}";
    }

    public static EPUBSquasherConfiguration copyOf(EPUBSquasherConfigurationType instance) {
        if (instance instanceof EPUBSquasherConfiguration) {
            return (EPUBSquasherConfiguration)instance;
        }
        return EPUBSquasherConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_INPUT_FILE = 1L;
        private static final long INIT_BIT_TEMPORARY_DIRECTORY = 2L;
        private static final long INIT_BIT_OUTPUT_FILE = 4L;
        private static final long INIT_BIT_MAXIMUM_IMAGE_WIDTH = 8L;
        private static final long INIT_BIT_MAXIMUM_IMAGE_HEIGHT = 16L;
        private static final long OPT_BIT_SCALE = 1L;
        private long initBits = 31L;
        private long optBits;
        private Path inputFile;
        private Path temporaryDirectory;
        private Path outputFile;
        private double scale;
        private double maximumImageWidth;
        private double maximumImageHeight;

        private Builder() {
        }

        public final Builder from(EPUBSquasherConfigurationType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setInputFile(instance.inputFile());
            this.setTemporaryDirectory(instance.temporaryDirectory());
            this.setOutputFile(instance.outputFile());
            this.setScale(instance.scale());
            this.setMaximumImageWidth(instance.maximumImageWidth());
            this.setMaximumImageHeight(instance.maximumImageHeight());
            return this;
        }

        public final Builder setInputFile(Path inputFile) {
            this.inputFile = Objects.requireNonNull(inputFile, "inputFile");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTemporaryDirectory(Path temporaryDirectory) {
            this.temporaryDirectory = Objects.requireNonNull(temporaryDirectory, "temporaryDirectory");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setOutputFile(Path outputFile) {
            this.outputFile = Objects.requireNonNull(outputFile, "outputFile");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setScale(double scale) {
            this.scale = scale;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setMaximumImageWidth(double maximumImageWidth) {
            this.maximumImageWidth = maximumImageWidth;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setMaximumImageHeight(double maximumImageHeight) {
            this.maximumImageHeight = maximumImageHeight;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public EPUBSquasherConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new EPUBSquasherConfiguration(this);
        }

        private boolean scaleIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("inputFile");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("temporaryDirectory");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("outputFile");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("maximumImageWidth");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("maximumImageHeight");
            }
            return "Cannot build EPUBSquasherConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

