/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.epubsquash.cmdline;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import one.lfa.epubsquash.cmdline.CommandRoot;
import one.lfa.epubsquash.cmdline.CommandSquash;
import one.lfa.epubsquash.cmdline.CommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private final Map<String, CommandType> commands;
    private final JCommander commander;
    private final String[] args;
    private int exit_code;

    public Main(String[] in_args) {
        this.args = Objects.requireNonNull(in_args, "args");
        CommandRoot r = new CommandRoot();
        CommandSquash cmd_squash = new CommandSquash();
        this.commands = new HashMap<String, CommandType>(8);
        this.commands.put("squash", cmd_squash);
        this.commander = new JCommander((Object)r);
        this.commander.setProgramName("epubsquash");
        this.commander.addCommand("squash", (Object)cmd_squash);
    }

    public static void main(String[] args) {
        Main cm = new Main(args);
        cm.run();
        System.exit(cm.exitCode());
    }

    public int exitCode() {
        return this.exit_code;
    }

    @Override
    public void run() {
        try {
            this.commander.parse(this.args);
            String cmd = this.commander.getParsedCommand();
            if (cmd == null) {
                StringBuilder sb = new StringBuilder(128);
                this.commander.usage(sb);
                LOG.info("Arguments required.\n{}", (Object)sb.toString());
                return;
            }
            CommandType command = this.commands.get(cmd);
            command.call();
        }
        catch (ParameterException e) {
            StringBuilder sb = new StringBuilder(128);
            this.commander.usage(sb);
            LOG.error("{}\n{}", (Object)e.getMessage(), (Object)sb.toString());
            this.exit_code = 1;
        }
        catch (Exception e) {
            LOG.error("{}", (Object)e.getMessage(), (Object)e);
            this.exit_code = 1;
        }
    }
}

