/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tiff;

import com.twelvemonkeys.lang.Validate;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

final class ExtraSamplesColorModel
extends ComponentColorModel {
    private final int numComponents;

    ExtraSamplesColorModel(ColorSpace colorSpace, boolean bl, boolean bl2, int n, int n2) {
        super(colorSpace, ExtraSamplesColorModel.bitsArrayHelper(colorSpace, n, n2 + (bl ? 1 : 0)), bl, bl2, 3, n);
        Validate.isTrue(n2 > 0, "Extra components must be > 0");
        this.numComponents = colorSpace.getNumComponents() + (bl ? 1 : 0) + n2;
    }

    private static int[] bitsArrayHelper(ColorSpace colorSpace, int n, int n2) {
        int n3 = DataBuffer.getDataTypeSize(n);
        int n4 = colorSpace.getNumComponents() + n2;
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = n3;
        }
        return nArray;
    }

    @Override
    public int getNumComponents() {
        return this.numComponents;
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        return this.numComponents == sampleModel.getNumBands() && this.transferType == sampleModel.getTransferType();
    }

    @Override
    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        if (!this.hasAlpha()) {
            return null;
        }
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int[] nArray = new int[]{this.getAlphaComponent()};
        return writableRaster.createWritableChild(n, n2, writableRaster.getWidth(), writableRaster.getHeight(), n, n2, nArray);
    }

    private int getAlphaComponent() {
        return super.getNumComponents() - 1;
    }
}

