/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.builders.BufferedImageBuilder;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Position;

public class Watermark
implements ImageFilter {
    private final Position position;
    private final BufferedImage watermarkImg;
    private final float opacity;

    public Watermark(Position position, BufferedImage bufferedImage, float f) {
        if (position == null) {
            throw new NullPointerException("Position is null.");
        }
        if (bufferedImage == null) {
            throw new NullPointerException("Watermark image is null.");
        }
        if (f > 1.0f || f < 0.0f) {
            throw new IllegalArgumentException("Opacity is out of range of between 0.0f and 1.0f.");
        }
        this.position = position;
        this.watermarkImg = bufferedImage;
        this.opacity = f;
    }

    public BufferedImage apply(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage.getType();
        BufferedImage bufferedImage2 = new BufferedImageBuilder(n, n2, n3).build();
        int n4 = this.watermarkImg.getWidth();
        int n5 = this.watermarkImg.getHeight();
        Point point = this.position.calculate(n, n2, n4, n5, 0, 0, 0, 0);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
        graphics2D.drawImage((Image)this.watermarkImg, point.x, point.y, null);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

