/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.epubsquash.tests;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import one.lfa.epubsquash.api.EPUBSquasherConfiguration;
import one.lfa.epubsquash.api.EPUBSquasherProviderType;
import one.lfa.epubsquash.api.EPUBSquasherType;
import one.lfa.epubsquash.tests.TestDirectories;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EPUBSquasherContract {
    private static final Logger LOG = LoggerFactory.getLogger(EPUBSquasherContract.class);
    private Path directory;

    private static InputStream resource(String name) throws IOException {
        String path = String.format("/one/lfa/epubsquash/tests/%s", name);
        URL url = EPUBSquasherContract.class.getResource(path);
        if (url == null) {
            throw new FileNotFoundException(path);
        }
        return url.openStream();
    }

    private static String hashOf(Path path) throws Exception {
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            byte[] digest;
            int r;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[8192];
            while ((r = stream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, r);
            }
            StringBuilder hash = new StringBuilder(128);
            for (byte b : digest = messageDigest.digest()) {
                hash.append(String.format("%02x", b));
            }
            String string = hash.toString();
            return string;
        }
    }

    @BeforeEach
    public void testSetup() throws IOException {
        this.directory = TestDirectories.temporaryDirectory();
    }

    @Test
    public void testUnpackDoNothingDeterministic() throws Exception {
        EPUBSquasherProviderType squashers = this.createSquashers();
        Path temp = this.directory.resolve("tmp");
        Path inputFile = this.directory.resolve("input.epub");
        Path outputFile0 = this.directory.resolve("output0.epub");
        Path outputFile1 = this.directory.resolve("output1.epub");
        Files.createDirectories(temp, new FileAttribute[0]);
        try (InputStream stream = EPUBSquasherContract.resource("pg27472-images.epub");){
            Files.copy(stream, inputFile, new CopyOption[0]);
        }
        EPUBSquasherConfiguration configuration0 = EPUBSquasherConfiguration.builder().setInputFile(inputFile).setOutputFile(outputFile0).setTemporaryDirectory(temp).setMaximumImageHeight(4000.0).setMaximumImageWidth(4000.0).setScale(1.0).build();
        EPUBSquasherType squasher0 = squashers.createSquasher(configuration0);
        squasher0.squash();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        EPUBSquasherConfiguration configuration1 = EPUBSquasherConfiguration.builder().setInputFile(inputFile).setOutputFile(outputFile1).setTemporaryDirectory(temp).setMaximumImageHeight(4000.0).setMaximumImageWidth(4000.0).setScale(1.0).build();
        EPUBSquasherType squasher1 = squashers.createSquasher(configuration1);
        squasher1.squash();
        Assertions.assertTrue((boolean)Files.isRegularFile(outputFile0, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.isRegularFile(outputFile1, new LinkOption[0]));
        String hash0 = EPUBSquasherContract.hashOf(outputFile0);
        String hash1 = EPUBSquasherContract.hashOf(outputFile1);
        LOG.debug("outputFile0: {}", (Object)hash0);
        LOG.debug("outputFile1: {}", (Object)hash1);
        Assertions.assertEquals((Object)hash0, (Object)hash1);
    }

    @Test
    public void testUnpackScale50Deterministic() throws Exception {
        EPUBSquasherProviderType squashers = this.createSquashers();
        Path temp = this.directory.resolve("tmp");
        Path inputFile = this.directory.resolve("input.epub");
        Path outputFile0 = this.directory.resolve("output0.epub");
        Path outputFile1 = this.directory.resolve("output1.epub");
        Files.createDirectories(temp, new FileAttribute[0]);
        try (InputStream stream = EPUBSquasherContract.resource("pg27472-images.epub");){
            Files.copy(stream, inputFile, new CopyOption[0]);
        }
        EPUBSquasherConfiguration configuration0 = EPUBSquasherConfiguration.builder().setInputFile(inputFile).setOutputFile(outputFile0).setTemporaryDirectory(temp).setMaximumImageHeight(4000.0).setMaximumImageWidth(4000.0).setScale(0.5).build();
        EPUBSquasherType squasher0 = squashers.createSquasher(configuration0);
        squasher0.squash();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        EPUBSquasherConfiguration configuration1 = EPUBSquasherConfiguration.builder().setInputFile(inputFile).setOutputFile(outputFile1).setTemporaryDirectory(temp).setMaximumImageHeight(4000.0).setMaximumImageWidth(4000.0).setScale(0.5).build();
        EPUBSquasherType squasher1 = squashers.createSquasher(configuration1);
        squasher1.squash();
        Assertions.assertTrue((boolean)Files.isRegularFile(outputFile0, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.isRegularFile(outputFile1, new LinkOption[0]));
        String hash0 = EPUBSquasherContract.hashOf(outputFile0);
        String hash1 = EPUBSquasherContract.hashOf(outputFile1);
        LOG.debug("outputFile0: {}", (Object)hash0);
        LOG.debug("outputFile1: {}", (Object)hash1);
        Assertions.assertEquals((Object)hash0, (Object)hash1);
    }

    protected abstract EPUBSquasherProviderType createSquashers();
}

