/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.epubsquash.vanilla.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import java.util.Set;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.resizers.configurations.Antialiasing;
import net.coobird.thumbnailator.resizers.configurations.ScalingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EPUBImageSquasher {
    private static final Logger LOG = LoggerFactory.getLogger(EPUBImageSquasher.class);
    private final Set<String> image_types = Set.of("image/jpeg");

    EPUBImageSquasher() {
    }

    boolean typeIsImage(String content_type) {
        return content_type != null && this.image_types.contains(content_type);
    }

    boolean isImage(Path path) throws IOException {
        Objects.requireNonNull(path, "path");
        return Files.isRegularFile(path, new LinkOption[0]) && this.typeIsImage(Files.probeContentType(path));
    }

    void squashImage(Path input, Path temp, Path output, double width, double height) throws IOException {
        Objects.requireNonNull(input, "input");
        Objects.requireNonNull(temp, "temp");
        Objects.requireNonNull(output, "output");
        LOG.debug("squashing image {} to {}x{}", new Object[]{input, width, height});
        Thumbnails.of((File[])new File[]{input.toFile()}).antialiasing(Antialiasing.ON).scalingMode(ScalingMode.BILINEAR).outputFormat("jpg").width((int)width).height((int)height).keepAspectRatio(true).outputQuality(0.9).toFile(temp.toFile());
        Files.move(temp, output, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
    }
}

