package one.lfa.opdsget.api;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The type of remote HTTP data.
 */
@Generated(from = "OPDSHTTPDataType", generator = "Immutables")
@SuppressWarnings({"all"})
public final class OPDSHTTPData implements OPDSHTTPDataType {
  private final long size;
  private final String contentType;
  private final InputStream stream;

  private OPDSHTTPData(long size, String contentType, InputStream stream) {
    this.size = size;
    this.contentType = Objects.requireNonNull(contentType, "contentType");
    this.stream = Objects.requireNonNull(stream, "stream");
  }

  private OPDSHTTPData(OPDSHTTPData.Builder builder) {
    this.size = builder.size;
    this.contentType = builder.contentType;
    this.stream = builder.stream;
  }

  /**
   * @return The size of the remote content
   */
  @Override
  public long size() {
    return size;
  }

  /**
   * @return The type of the remote content
   */
  @Override
  public String contentType() {
    return contentType;
  }

  /**
   * @return The input stream for the remote content
   */
  @Override
  public InputStream stream() {
    return stream;
  }

  /**
   * This instance is equal to all instances of {@code OPDSHTTPData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OPDSHTTPData
        && equalTo((OPDSHTTPData) another);
  }

  private boolean equalTo(OPDSHTTPData another) {
    return size == another.size
        && contentType.equals(another.contentType)
        && stream.equals(another.stream);
  }

  /**
   * Computes a hash code from attributes: {@code size}, {@code contentType}, {@code stream}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Long.hashCode(size);
    h += (h << 5) + contentType.hashCode();
    h += (h << 5) + stream.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OPDSHTTPData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OPDSHTTPData{"
        + "size=" + size
        + ", contentType=" + contentType
        + ", stream=" + stream
        + "}";
  }

  /**
   * Construct a new immutable {@code OPDSHTTPData} instance.
   * @param size The value for the {@code size} attribute
   * @param contentType The value for the {@code contentType} attribute
   * @param stream The value for the {@code stream} attribute
   * @return An immutable OPDSHTTPData instance
   */
  public static OPDSHTTPData of(long size, String contentType, InputStream stream) {
    return new OPDSHTTPData(size, contentType, stream);
  }

  /**
   * Creates a builder for {@link OPDSHTTPData OPDSHTTPData}.
   * <pre>
   * OPDSHTTPData.builder()
   *    .setSize(long) // required {@link OPDSHTTPDataType#size() size}
   *    .setContentType(String) // required {@link OPDSHTTPDataType#contentType() contentType}
   *    .setStream(java.io.InputStream) // required {@link OPDSHTTPDataType#stream() stream}
   *    .build();
   * </pre>
   * @return A new OPDSHTTPData builder
   */
  public static OPDSHTTPData.Builder builder() {
    return new OPDSHTTPData.Builder();
  }

  /**
   * Builds instances of type {@link OPDSHTTPData OPDSHTTPData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OPDSHTTPDataType", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SIZE = 0x1L;
    private static final long INIT_BIT_CONTENT_TYPE = 0x2L;
    private static final long INIT_BIT_STREAM = 0x4L;
    private long initBits = 0x7L;

    private long size;
    private String contentType;
    private InputStream stream;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OPDSHTTPDataType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OPDSHTTPDataType instance) {
      Objects.requireNonNull(instance, "instance");
      setSize(instance.size());
      setContentType(instance.contentType());
      setStream(instance.stream());
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSHTTPDataType#size() size} attribute.
     * @param size The value for size 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSize(long size) {
      this.size = size;
      initBits &= ~INIT_BIT_SIZE;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSHTTPDataType#contentType() contentType} attribute.
     * @param contentType The value for contentType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setContentType(String contentType) {
      this.contentType = Objects.requireNonNull(contentType, "contentType");
      initBits &= ~INIT_BIT_CONTENT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSHTTPDataType#stream() stream} attribute.
     * @param stream The value for stream 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setStream(InputStream stream) {
      this.stream = Objects.requireNonNull(stream, "stream");
      initBits &= ~INIT_BIT_STREAM;
      return this;
    }

    /**
     * Builds a new {@link OPDSHTTPData OPDSHTTPData}.
     * @return An immutable instance of OPDSHTTPData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OPDSHTTPData build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OPDSHTTPData(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SIZE) != 0) attributes.add("size");
      if ((initBits & INIT_BIT_CONTENT_TYPE) != 0) attributes.add("contentType");
      if ((initBits & INIT_BIT_STREAM) != 0) attributes.add("stream");
      return "Cannot build OPDSHTTPData, some of required attributes are not set " + attributes;
    }
  }
}
