package one.lfa.opdsget.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * A file entry.
 */
@Generated(from = "OPDSManifestDescriptionType.FileEntryType", generator = "Immutables")
@SuppressWarnings({"all"})
public final class FileEntry implements OPDSManifestDescriptionType.FileEntryType {
  private final String path;
  private final String hashAlgorithm;
  private final byte[] hash;

  private FileEntry(FileEntry.Builder builder) {
    this.path = builder.path;
    this.hashAlgorithm = builder.hashAlgorithm;
    this.hash = builder.hash;
  }

  /**
   * @return The path of the file
   */
  @Override
  public String path() {
    return path;
  }

  /**
   * @return The hash algorithm used to produce the file hash
   */
  @Override
  public String hashAlgorithm() {
    return hashAlgorithm;
  }

  /**
   * @return The hash of the file content
   */
  @Override
  public byte[] hash() {
    return hash.clone();
  }

  /**
   * This instance is equal to all instances of {@code FileEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof FileEntry
        && equalTo((FileEntry) another);
  }

  private boolean equalTo(FileEntry another) {
    return path.equals(another.path)
        && hashAlgorithm.equals(another.hashAlgorithm)
        && Arrays.equals(hash, another.hash);
  }

  /**
   * Computes a hash code from attributes: {@code path}, {@code hashAlgorithm}, {@code hash}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + path.hashCode();
    h += (h << 5) + hashAlgorithm.hashCode();
    h += (h << 5) + Arrays.hashCode(hash);
    return h;
  }

  /**
   * Prints the immutable value {@code FileEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FileEntry{"
        + "path=" + path
        + ", hashAlgorithm=" + hashAlgorithm
        + ", hash=" + Arrays.toString(hash)
        + "}";
  }

  /**
   * Creates a builder for {@link FileEntry FileEntry}.
   * <pre>
   * FileEntry.builder()
   *    .setPath(String) // required {@link OPDSManifestDescriptionType.FileEntryType#path() path}
   *    .setHashAlgorithm(String) // required {@link OPDSManifestDescriptionType.FileEntryType#hashAlgorithm() hashAlgorithm}
   *    .setHash(byte) // required {@link OPDSManifestDescriptionType.FileEntryType#hash() hash}
   *    .build();
   * </pre>
   * @return A new FileEntry builder
   */
  public static FileEntry.Builder builder() {
    return new FileEntry.Builder();
  }

  /**
   * Builds instances of type {@link FileEntry FileEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OPDSManifestDescriptionType.FileEntryType", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PATH = 0x1L;
    private static final long INIT_BIT_HASH_ALGORITHM = 0x2L;
    private static final long INIT_BIT_HASH = 0x4L;
    private long initBits = 0x7L;

    private String path;
    private String hashAlgorithm;
    private byte[] hash;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FileEntryType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OPDSManifestDescriptionType.FileEntryType instance) {
      Objects.requireNonNull(instance, "instance");
      setPath(instance.path());
      setHashAlgorithm(instance.hashAlgorithm());
      setHash(instance.hash());
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSManifestDescriptionType.FileEntryType#path() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPath(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSManifestDescriptionType.FileEntryType#hashAlgorithm() hashAlgorithm} attribute.
     * @param hashAlgorithm The value for hashAlgorithm 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHashAlgorithm(String hashAlgorithm) {
      this.hashAlgorithm = Objects.requireNonNull(hashAlgorithm, "hashAlgorithm");
      initBits &= ~INIT_BIT_HASH_ALGORITHM;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSManifestDescriptionType.FileEntryType#hash() hash} attribute.
     * @param hash The elements for hash
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHash(byte... hash) {
      this.hash = hash.clone();
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Builds a new {@link FileEntry FileEntry}.
     * @return An immutable instance of FileEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public FileEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new FileEntry(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      if ((initBits & INIT_BIT_HASH_ALGORITHM) != 0) attributes.add("hashAlgorithm");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      return "Cannot build FileEntry, some of required attributes are not set " + attributes;
    }
  }
}
