package one.lfa.opdsget.api;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The result of processing a single OPDS feed document.
 */
@Generated(from = "OPDSDocumentProcessedType", generator = "Immutables")
@SuppressWarnings({"all"})
public final class OPDSDocumentProcessed implements OPDSDocumentProcessedType {
  private final Map<URI, OPDSLocalFile> feeds;
  private final Map<URI, OPDSLocalFile> images;
  private final Map<URI, OPDSLocalFile> books;
  private final OPDSLocalFile file;
  private final boolean entry;
  private final String title;

  private OPDSDocumentProcessed(
      Map<? extends URI, ? extends OPDSLocalFile> feeds,
      Map<? extends URI, ? extends OPDSLocalFile> images,
      Map<? extends URI, ? extends OPDSLocalFile> books,
      OPDSLocalFile file,
      boolean entry,
      String title) {
    this.feeds = createUnmodifiableMap(true, false, feeds);
    this.images = createUnmodifiableMap(true, false, images);
    this.books = createUnmodifiableMap(true, false, books);
    this.file = Objects.requireNonNull(file, "file");
    this.entry = entry;
    this.title = Objects.requireNonNull(title, "title");
    this.initShim = null;
  }

  private OPDSDocumentProcessed(OPDSDocumentProcessed.Builder builder) {
    this.file = builder.file;
    this.entry = builder.entry;
    this.title = builder.title;
    if (builder.feedsIsSet()) {
      initShim.setFeeds(createUnmodifiableMap(false, false, builder.feeds));
    }
    if (builder.imagesIsSet()) {
      initShim.setImages(createUnmodifiableMap(false, false, builder.images));
    }
    if (builder.booksIsSet()) {
      initShim.setBooks(createUnmodifiableMap(false, false, builder.books));
    }
    this.feeds = initShim.feeds();
    this.images = initShim.images();
    this.books = initShim.books();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "OPDSDocumentProcessedType", generator = "Immutables")
  private final class InitShim {
    private byte feedsBuildStage = STAGE_UNINITIALIZED;
    private Map<URI, OPDSLocalFile> feeds;

    Map<URI, OPDSLocalFile> feeds() {
      if (feedsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (feedsBuildStage == STAGE_UNINITIALIZED) {
        feedsBuildStage = STAGE_INITIALIZING;
        this.feeds = createUnmodifiableMap(true, false, feedsInitialize());
        feedsBuildStage = STAGE_INITIALIZED;
      }
      return this.feeds;
    }

    void setFeeds(Map<URI, OPDSLocalFile> feeds) {
      this.feeds = feeds;
      feedsBuildStage = STAGE_INITIALIZED;
    }

    private byte imagesBuildStage = STAGE_UNINITIALIZED;
    private Map<URI, OPDSLocalFile> images;

    Map<URI, OPDSLocalFile> images() {
      if (imagesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (imagesBuildStage == STAGE_UNINITIALIZED) {
        imagesBuildStage = STAGE_INITIALIZING;
        this.images = createUnmodifiableMap(true, false, imagesInitialize());
        imagesBuildStage = STAGE_INITIALIZED;
      }
      return this.images;
    }

    void setImages(Map<URI, OPDSLocalFile> images) {
      this.images = images;
      imagesBuildStage = STAGE_INITIALIZED;
    }

    private byte booksBuildStage = STAGE_UNINITIALIZED;
    private Map<URI, OPDSLocalFile> books;

    Map<URI, OPDSLocalFile> books() {
      if (booksBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (booksBuildStage == STAGE_UNINITIALIZED) {
        booksBuildStage = STAGE_INITIALIZING;
        this.books = createUnmodifiableMap(true, false, booksInitialize());
        booksBuildStage = STAGE_INITIALIZED;
      }
      return this.books;
    }

    void setBooks(Map<URI, OPDSLocalFile> books) {
      this.books = books;
      booksBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (feedsBuildStage == STAGE_INITIALIZING) attributes.add("feeds");
      if (imagesBuildStage == STAGE_INITIALIZING) attributes.add("images");
      if (booksBuildStage == STAGE_INITIALIZING) attributes.add("books");
      return "Cannot build OPDSDocumentProcessed, attribute initializers form cycle " + attributes;
    }
  }

  private Map<URI, OPDSLocalFile> feedsInitialize() {
    return OPDSDocumentProcessedType.super.feeds();
  }

  private Map<URI, OPDSLocalFile> imagesInitialize() {
    return OPDSDocumentProcessedType.super.images();
  }

  private Map<URI, OPDSLocalFile> booksInitialize() {
    return OPDSDocumentProcessedType.super.books();
  }

  /**
   * @return The set of feeds that need to be fetched
   */
  @Override
  public Map<URI, OPDSLocalFile> feeds() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.feeds()
        : this.feeds;
  }

  /**
   * @return The set of images that need to be fetched
   */
  @Override
  public Map<URI, OPDSLocalFile> images() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.images()
        : this.images;
  }

  /**
   * @return The set of books that need to be fetched
   */
  @Override
  public Map<URI, OPDSLocalFile> books() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.books()
        : this.books;
  }

  /**
   * @return The path to the saved feed file
   */
  @Override
  public OPDSLocalFile file() {
    return file;
  }

  /**
   * @return {@code true} iff the document is an OPDS entry
   */
  @Override
  public boolean isEntry() {
    return entry;
  }

  /**
   * @return The title of the document
   */
  @Override
  public String title() {
    return title;
  }

  /**
   * This instance is equal to all instances of {@code OPDSDocumentProcessed} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OPDSDocumentProcessed
        && equalTo((OPDSDocumentProcessed) another);
  }

  private boolean equalTo(OPDSDocumentProcessed another) {
    return feeds.equals(another.feeds)
        && images.equals(another.images)
        && books.equals(another.books)
        && file.equals(another.file)
        && entry == another.entry
        && title.equals(another.title);
  }

  /**
   * Computes a hash code from attributes: {@code feeds}, {@code images}, {@code books}, {@code file}, {@code entry}, {@code title}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + feeds.hashCode();
    h += (h << 5) + images.hashCode();
    h += (h << 5) + books.hashCode();
    h += (h << 5) + file.hashCode();
    h += (h << 5) + Boolean.hashCode(entry);
    h += (h << 5) + title.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OPDSDocumentProcessed} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OPDSDocumentProcessed{"
        + "feeds=" + feeds
        + ", images=" + images
        + ", books=" + books
        + ", file=" + file
        + ", entry=" + entry
        + ", title=" + title
        + "}";
  }

  /**
   * Construct a new immutable {@code OPDSDocumentProcessed} instance.
   * @param feeds The value for the {@code feeds} attribute
   * @param images The value for the {@code images} attribute
   * @param books The value for the {@code books} attribute
   * @param file The value for the {@code file} attribute
   * @param entry The value for the {@code entry} attribute
   * @param title The value for the {@code title} attribute
   * @return An immutable OPDSDocumentProcessed instance
   */
  public static OPDSDocumentProcessed of(Map<? extends URI, ? extends OPDSLocalFile> feeds, Map<? extends URI, ? extends OPDSLocalFile> images, Map<? extends URI, ? extends OPDSLocalFile> books, OPDSLocalFile file, boolean entry, String title) {
    return validate(new OPDSDocumentProcessed(feeds, images, books, file, entry, title));
  }

  private static OPDSDocumentProcessed validate(OPDSDocumentProcessed instance) {
    instance.checkPreconditions();
    return instance;
  }

  /**
   * Creates a builder for {@link OPDSDocumentProcessed OPDSDocumentProcessed}.
   * <pre>
   * OPDSDocumentProcessed.builder()
   *    .putFeeds|putAllFeeds(java.net.URI =&gt; OPDSLocalFile) // {@link OPDSDocumentProcessedType#feeds() feeds} mappings
   *    .putImages|putAllImages(java.net.URI =&gt; OPDSLocalFile) // {@link OPDSDocumentProcessedType#images() images} mappings
   *    .putBooks|putAllBooks(java.net.URI =&gt; OPDSLocalFile) // {@link OPDSDocumentProcessedType#books() books} mappings
   *    .setFile(one.lfa.opdsget.api.OPDSLocalFile) // required {@link OPDSDocumentProcessedType#file() file}
   *    .setEntry(boolean) // required {@link OPDSDocumentProcessedType#isEntry() entry}
   *    .setTitle(String) // required {@link OPDSDocumentProcessedType#title() title}
   *    .build();
   * </pre>
   * @return A new OPDSDocumentProcessed builder
   */
  public static OPDSDocumentProcessed.Builder builder() {
    return new OPDSDocumentProcessed.Builder();
  }

  /**
   * Builds instances of type {@link OPDSDocumentProcessed OPDSDocumentProcessed}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OPDSDocumentProcessedType", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_FILE = 0x1L;
    private static final long INIT_BIT_ENTRY = 0x2L;
    private static final long INIT_BIT_TITLE = 0x4L;
    private static final long OPT_BIT_FEEDS = 0x1L;
    private static final long OPT_BIT_IMAGES = 0x2L;
    private static final long OPT_BIT_BOOKS = 0x4L;
    private long initBits = 0x7L;
    private long optBits;

    private Map<URI, OPDSLocalFile> feeds = new LinkedHashMap<URI, OPDSLocalFile>();
    private Map<URI, OPDSLocalFile> images = new LinkedHashMap<URI, OPDSLocalFile>();
    private Map<URI, OPDSLocalFile> books = new LinkedHashMap<URI, OPDSLocalFile>();
    private OPDSLocalFile file;
    private boolean entry;
    private String title;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OPDSDocumentProcessedType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OPDSDocumentProcessedType instance) {
      Objects.requireNonNull(instance, "instance");
      putAllFeeds(instance.feeds());
      putAllImages(instance.images());
      putAllBooks(instance.books());
      setFile(instance.file());
      setEntry(instance.isEntry());
      setTitle(instance.title());
      return this;
    }

    /**
     * Put one entry to the {@link OPDSDocumentProcessedType#feeds() feeds} map.
     * @param key The key in the feeds map
     * @param value The associated value in the feeds map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putFeeds(URI key, OPDSLocalFile value) {
      this.feeds.put(
          Objects.requireNonNull(key, "feeds key"),
          Objects.requireNonNull(value, "feeds value"));
      optBits |= OPT_BIT_FEEDS;
      return this;
    }

    /**
     * Put one entry to the {@link OPDSDocumentProcessedType#feeds() feeds} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putFeeds(Map.Entry<? extends URI, ? extends OPDSLocalFile> entry) {
      URI k = entry.getKey();
      OPDSLocalFile v = entry.getValue();
      this.feeds.put(
          Objects.requireNonNull(k, "feeds key"),
          Objects.requireNonNull(v, "feeds value"));
      optBits |= OPT_BIT_FEEDS;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OPDSDocumentProcessedType#feeds() feeds} map. Nulls are not permitted
     * @param entries The entries that will be added to the feeds map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFeeds(Map<? extends URI, ? extends OPDSLocalFile> entries) {
      this.feeds.clear();
      optBits |= OPT_BIT_FEEDS;
      return putAllFeeds(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OPDSDocumentProcessedType#feeds() feeds} map. Nulls are not permitted
     * @param entries The entries that will be added to the feeds map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllFeeds(Map<? extends URI, ? extends OPDSLocalFile> entries) {
      for (Map.Entry<? extends URI, ? extends OPDSLocalFile> e : entries.entrySet()) {
        URI k = e.getKey();
        OPDSLocalFile v = e.getValue();
        this.feeds.put(
            Objects.requireNonNull(k, "feeds key"),
            Objects.requireNonNull(v, "feeds value"));
      }
      optBits |= OPT_BIT_FEEDS;
      return this;
    }

    /**
     * Put one entry to the {@link OPDSDocumentProcessedType#images() images} map.
     * @param key The key in the images map
     * @param value The associated value in the images map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putImages(URI key, OPDSLocalFile value) {
      this.images.put(
          Objects.requireNonNull(key, "images key"),
          Objects.requireNonNull(value, "images value"));
      optBits |= OPT_BIT_IMAGES;
      return this;
    }

    /**
     * Put one entry to the {@link OPDSDocumentProcessedType#images() images} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putImages(Map.Entry<? extends URI, ? extends OPDSLocalFile> entry) {
      URI k = entry.getKey();
      OPDSLocalFile v = entry.getValue();
      this.images.put(
          Objects.requireNonNull(k, "images key"),
          Objects.requireNonNull(v, "images value"));
      optBits |= OPT_BIT_IMAGES;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OPDSDocumentProcessedType#images() images} map. Nulls are not permitted
     * @param entries The entries that will be added to the images map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImages(Map<? extends URI, ? extends OPDSLocalFile> entries) {
      this.images.clear();
      optBits |= OPT_BIT_IMAGES;
      return putAllImages(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OPDSDocumentProcessedType#images() images} map. Nulls are not permitted
     * @param entries The entries that will be added to the images map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllImages(Map<? extends URI, ? extends OPDSLocalFile> entries) {
      for (Map.Entry<? extends URI, ? extends OPDSLocalFile> e : entries.entrySet()) {
        URI k = e.getKey();
        OPDSLocalFile v = e.getValue();
        this.images.put(
            Objects.requireNonNull(k, "images key"),
            Objects.requireNonNull(v, "images value"));
      }
      optBits |= OPT_BIT_IMAGES;
      return this;
    }

    /**
     * Put one entry to the {@link OPDSDocumentProcessedType#books() books} map.
     * @param key The key in the books map
     * @param value The associated value in the books map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putBooks(URI key, OPDSLocalFile value) {
      this.books.put(
          Objects.requireNonNull(key, "books key"),
          Objects.requireNonNull(value, "books value"));
      optBits |= OPT_BIT_BOOKS;
      return this;
    }

    /**
     * Put one entry to the {@link OPDSDocumentProcessedType#books() books} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putBooks(Map.Entry<? extends URI, ? extends OPDSLocalFile> entry) {
      URI k = entry.getKey();
      OPDSLocalFile v = entry.getValue();
      this.books.put(
          Objects.requireNonNull(k, "books key"),
          Objects.requireNonNull(v, "books value"));
      optBits |= OPT_BIT_BOOKS;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OPDSDocumentProcessedType#books() books} map. Nulls are not permitted
     * @param entries The entries that will be added to the books map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBooks(Map<? extends URI, ? extends OPDSLocalFile> entries) {
      this.books.clear();
      optBits |= OPT_BIT_BOOKS;
      return putAllBooks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OPDSDocumentProcessedType#books() books} map. Nulls are not permitted
     * @param entries The entries that will be added to the books map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllBooks(Map<? extends URI, ? extends OPDSLocalFile> entries) {
      for (Map.Entry<? extends URI, ? extends OPDSLocalFile> e : entries.entrySet()) {
        URI k = e.getKey();
        OPDSLocalFile v = e.getValue();
        this.books.put(
            Objects.requireNonNull(k, "books key"),
            Objects.requireNonNull(v, "books value"));
      }
      optBits |= OPT_BIT_BOOKS;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSDocumentProcessedType#file() file} attribute.
     * @param file The value for file 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFile(OPDSLocalFile file) {
      this.file = Objects.requireNonNull(file, "file");
      initBits &= ~INIT_BIT_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSDocumentProcessedType#isEntry() entry} attribute.
     * @param entry The value for entry 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEntry(boolean entry) {
      this.entry = entry;
      initBits &= ~INIT_BIT_ENTRY;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSDocumentProcessedType#title() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Builds a new {@link OPDSDocumentProcessed OPDSDocumentProcessed}.
     * @return An immutable instance of OPDSDocumentProcessed
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OPDSDocumentProcessed build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return OPDSDocumentProcessed.validate(new OPDSDocumentProcessed(this));
    }

    private boolean feedsIsSet() {
      return (optBits & OPT_BIT_FEEDS) != 0;
    }

    private boolean imagesIsSet() {
      return (optBits & OPT_BIT_IMAGES) != 0;
    }

    private boolean booksIsSet() {
      return (optBits & OPT_BIT_BOOKS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FILE) != 0) attributes.add("file");
      if ((initBits & INIT_BIT_ENTRY) != 0) attributes.add("entry");
      if ((initBits & INIT_BIT_TITLE) != 0) attributes.add("title");
      return "Cannot build OPDSDocumentProcessed, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
