package one.lfa.opdsget.api;

import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.immutables.value.Generated;

/**
 * A description of a manifest.
 * A manifest is a list of all of the files that make up an OPDS feed.
 */
@Generated(from = "OPDSManifestDescriptionType", generator = "Immutables")
@SuppressWarnings({"all"})
public final class OPDSManifestDescription implements OPDSManifestDescriptionType {
  private final UUID id;
  private final String rootFile;
  private final OffsetDateTime updated;
  private final String searchIndex;
  private final URI base;
  private final Map<URI, FileEntry> files;

  private OPDSManifestDescription(OPDSManifestDescription.Builder builder) {
    this.id = builder.id;
    this.rootFile = builder.rootFile;
    this.searchIndex = builder.searchIndex;
    this.base = builder.base;
    this.files = createUnmodifiableMap(false, false, builder.files);
    this.updated = builder.updated != null
        ? builder.updated
        : Objects.requireNonNull(OPDSManifestDescriptionType.super.updated(), "updated");
  }

  /**
   * @return The unique ID of the feed
   */
  @Override
  public UUID id() {
    return id;
  }

  /**
   * @return The file that represents the root of the feed
   */
  @Override
  public String rootFile() {
    return rootFile;
  }

  /**
   * @return The time the manifest was generated
   */
  @Override
  public OffsetDateTime updated() {
    return updated;
  }

  /**
   * @return The file that represents the search index of the feed
   */
  @Override
  public Optional<String> searchIndex() {
    return Optional.ofNullable(searchIndex);
  }

  /**
   * @return The base URI of the feed, if one was provided
   */
  @Override
  public Optional<URI> base() {
    return Optional.ofNullable(base);
  }

  /**
   * @return The files that make up the feed
   */
  @Override
  public Map<URI, FileEntry> files() {
    return files;
  }

  /**
   * This instance is equal to all instances of {@code OPDSManifestDescription} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OPDSManifestDescription
        && equalTo((OPDSManifestDescription) another);
  }

  private boolean equalTo(OPDSManifestDescription another) {
    return id.equals(another.id)
        && rootFile.equals(another.rootFile)
        && updated.equals(another.updated)
        && Objects.equals(searchIndex, another.searchIndex)
        && Objects.equals(base, another.base)
        && files.equals(another.files);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rootFile}, {@code updated}, {@code searchIndex}, {@code base}, {@code files}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rootFile.hashCode();
    h += (h << 5) + updated.hashCode();
    h += (h << 5) + Objects.hashCode(searchIndex);
    h += (h << 5) + Objects.hashCode(base);
    h += (h << 5) + files.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OPDSManifestDescription} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("OPDSManifestDescription{");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("rootFile=").append(rootFile);
    builder.append(", ");
    builder.append("updated=").append(updated);
    if (searchIndex != null) {
      builder.append(", ");
      builder.append("searchIndex=").append(searchIndex);
    }
    if (base != null) {
      builder.append(", ");
      builder.append("base=").append(base);
    }
    builder.append(", ");
    builder.append("files=").append(files);
    return builder.append("}").toString();
  }

  /**
   * Creates a builder for {@link OPDSManifestDescription OPDSManifestDescription}.
   * <pre>
   * OPDSManifestDescription.builder()
   *    .setId(UUID) // required {@link OPDSManifestDescriptionType#id() id}
   *    .setRootFile(String) // required {@link OPDSManifestDescriptionType#rootFile() rootFile}
   *    .setUpdated(java.time.OffsetDateTime) // optional {@link OPDSManifestDescriptionType#updated() updated}
   *    .setSearchIndex(String) // optional {@link OPDSManifestDescriptionType#searchIndex() searchIndex}
   *    .setBase(java.net.URI) // optional {@link OPDSManifestDescriptionType#base() base}
   *    .putFiles|putAllFiles(java.net.URI =&gt; FileEntry) // {@link OPDSManifestDescriptionType#files() files} mappings
   *    .build();
   * </pre>
   * @return A new OPDSManifestDescription builder
   */
  public static OPDSManifestDescription.Builder builder() {
    return new OPDSManifestDescription.Builder();
  }

  /**
   * Builds instances of type {@link OPDSManifestDescription OPDSManifestDescription}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OPDSManifestDescriptionType", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_ROOT_FILE = 0x2L;
    private long initBits = 0x3L;

    private UUID id;
    private String rootFile;
    private OffsetDateTime updated;
    private String searchIndex;
    private URI base;
    private Map<URI, FileEntry> files = new LinkedHashMap<URI, FileEntry>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OPDSManifestDescriptionType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OPDSManifestDescriptionType instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.id());
      setRootFile(instance.rootFile());
      setUpdated(instance.updated());
      Optional<String> searchIndexOptional = instance.searchIndex();
      if (searchIndexOptional.isPresent()) {
        setSearchIndex(searchIndexOptional);
      }
      Optional<URI> baseOptional = instance.base();
      if (baseOptional.isPresent()) {
        setBase(baseOptional);
      }
      putAllFiles(instance.files());
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSManifestDescriptionType#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setId(UUID id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSManifestDescriptionType#rootFile() rootFile} attribute.
     * @param rootFile The value for rootFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRootFile(String rootFile) {
      this.rootFile = Objects.requireNonNull(rootFile, "rootFile");
      initBits &= ~INIT_BIT_ROOT_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSManifestDescriptionType#updated() updated} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link OPDSManifestDescriptionType#updated() updated}.</em>
     * @param updated The value for updated 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUpdated(OffsetDateTime updated) {
      this.updated = Objects.requireNonNull(updated, "updated");
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSManifestDescriptionType#searchIndex() searchIndex} to searchIndex.
     * @param searchIndex The value for searchIndex
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSearchIndex(String searchIndex) {
      this.searchIndex = Objects.requireNonNull(searchIndex, "searchIndex");
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSManifestDescriptionType#searchIndex() searchIndex} to searchIndex.
     * @param searchIndex The value for searchIndex
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSearchIndex(Optional<String> searchIndex) {
      this.searchIndex = searchIndex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSManifestDescriptionType#base() base} to base.
     * @param base The value for base
     * @return {@code this} builder for chained invocation
     */
    public final Builder setBase(URI base) {
      this.base = Objects.requireNonNull(base, "base");
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSManifestDescriptionType#base() base} to base.
     * @param base The value for base
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBase(Optional<? extends URI> base) {
      this.base = base.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link OPDSManifestDescriptionType#files() files} map.
     * @param key The key in the files map
     * @param value The associated value in the files map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putFiles(URI key, FileEntry value) {
      this.files.put(
          Objects.requireNonNull(key, "files key"),
          Objects.requireNonNull(value, "files value"));
      return this;
    }

    /**
     * Put one entry to the {@link OPDSManifestDescriptionType#files() files} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putFiles(Map.Entry<? extends URI, ? extends FileEntry> entry) {
      URI k = entry.getKey();
      FileEntry v = entry.getValue();
      this.files.put(
          Objects.requireNonNull(k, "files key"),
          Objects.requireNonNull(v, "files value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OPDSManifestDescriptionType#files() files} map. Nulls are not permitted
     * @param entries The entries that will be added to the files map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFiles(Map<? extends URI, ? extends FileEntry> entries) {
      this.files.clear();
      return putAllFiles(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OPDSManifestDescriptionType#files() files} map. Nulls are not permitted
     * @param entries The entries that will be added to the files map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllFiles(Map<? extends URI, ? extends FileEntry> entries) {
      for (Map.Entry<? extends URI, ? extends FileEntry> e : entries.entrySet()) {
        URI k = e.getKey();
        FileEntry v = e.getValue();
        this.files.put(
            Objects.requireNonNull(k, "files key"),
            Objects.requireNonNull(v, "files value"));
      }
      return this;
    }

    /**
     * Builds a new {@link OPDSManifestDescription OPDSManifestDescription}.
     * @return An immutable instance of OPDSManifestDescription
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OPDSManifestDescription build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OPDSManifestDescription(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_ROOT_FILE) != 0) attributes.add("rootFile");
      return "Cannot build OPDSManifestDescription, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
