package one.lfa.opdsget.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.immutables.value.Generated;

/**
 * An authentication value that is applied when a URI matches the given pattern.
 */
@Generated(from = "OPDSMatchingAuthenticationType", generator = "Immutables")
@SuppressWarnings({"all"})
public final class OPDSMatchingAuthentication implements OPDSMatchingAuthenticationType {
  private final String patternText;
  private transient final Pattern pattern;
  private final OPDSAuthenticationType authentication;

  @SuppressWarnings("unchecked") // safe covariant cast
  private OPDSMatchingAuthentication(
      String patternText,
      Optional<? extends OPDSAuthenticationType> authentication) {
    this.patternText = Objects.requireNonNull(patternText, "patternText");
    this.authentication = authentication.orElse(null);
    this.pattern = Objects.requireNonNull(OPDSMatchingAuthenticationType.super.pattern(), "pattern");
  }

  private OPDSMatchingAuthentication(OPDSMatchingAuthentication.Builder builder) {
    this.patternText = builder.patternText;
    this.authentication = builder.authentication;
    this.pattern = Objects.requireNonNull(OPDSMatchingAuthenticationType.super.pattern(), "pattern");
  }

  /**
   * @return The text of the pattern against which a URI is matched
   */
  @Override
  public String patternText() {
    return patternText;
  }

  /**
   * @return The pattern against which a URI is matched
   */
  @Override
  public Pattern pattern() {
    return pattern;
  }

  /**
   * @return The authentication data if any
   */
  @Override
  public Optional<OPDSAuthenticationType> authentication() {
    return Optional.ofNullable(authentication);
  }

  /**
   * This instance is equal to all instances of {@code OPDSMatchingAuthentication} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OPDSMatchingAuthentication
        && equalTo((OPDSMatchingAuthentication) another);
  }

  private boolean equalTo(OPDSMatchingAuthentication another) {
    return patternText.equals(another.patternText)
        && Objects.equals(authentication, another.authentication);
  }

  /**
   * Computes a hash code from attributes: {@code patternText}, {@code authentication}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + patternText.hashCode();
    h += (h << 5) + Objects.hashCode(authentication);
    return h;
  }

  /**
   * Prints the immutable value {@code OPDSMatchingAuthentication} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("OPDSMatchingAuthentication{");
    builder.append("patternText=").append(patternText);
    if (authentication != null) {
      builder.append(", ");
      builder.append("authentication=").append(authentication);
    }
    return builder.append("}").toString();
  }

  /**
   * Construct a new immutable {@code OPDSMatchingAuthentication} instance.
   * @param patternText The value for the {@code patternText} attribute
   * @param authentication The value for the {@code authentication} attribute
   * @return An immutable OPDSMatchingAuthentication instance
   */
  public static OPDSMatchingAuthentication of(String patternText, Optional<? extends OPDSAuthenticationType> authentication) {
    return new OPDSMatchingAuthentication(patternText, authentication);
  }

  /**
   * Creates a builder for {@link OPDSMatchingAuthentication OPDSMatchingAuthentication}.
   * <pre>
   * OPDSMatchingAuthentication.builder()
   *    .setPatternText(String) // required {@link OPDSMatchingAuthenticationType#patternText() patternText}
   *    .setAuthentication(one.lfa.opdsget.api.OPDSAuthenticationType) // optional {@link OPDSMatchingAuthenticationType#authentication() authentication}
   *    .build();
   * </pre>
   * @return A new OPDSMatchingAuthentication builder
   */
  public static OPDSMatchingAuthentication.Builder builder() {
    return new OPDSMatchingAuthentication.Builder();
  }

  /**
   * Builds instances of type {@link OPDSMatchingAuthentication OPDSMatchingAuthentication}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OPDSMatchingAuthenticationType", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PATTERN_TEXT = 0x1L;
    private long initBits = 0x1L;

    private String patternText;
    private OPDSAuthenticationType authentication;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OPDSMatchingAuthenticationType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OPDSMatchingAuthenticationType instance) {
      Objects.requireNonNull(instance, "instance");
      setPatternText(instance.patternText());
      Optional<OPDSAuthenticationType> authenticationOptional = instance.authentication();
      if (authenticationOptional.isPresent()) {
        setAuthentication(authenticationOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSMatchingAuthenticationType#patternText() patternText} attribute.
     * @param patternText The value for patternText 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPatternText(String patternText) {
      this.patternText = Objects.requireNonNull(patternText, "patternText");
      initBits &= ~INIT_BIT_PATTERN_TEXT;
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSMatchingAuthenticationType#authentication() authentication} to authentication.
     * @param authentication The value for authentication
     * @return {@code this} builder for chained invocation
     */
    public final Builder setAuthentication(OPDSAuthenticationType authentication) {
      this.authentication = Objects.requireNonNull(authentication, "authentication");
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSMatchingAuthenticationType#authentication() authentication} to authentication.
     * @param authentication The value for authentication
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAuthentication(Optional<? extends OPDSAuthenticationType> authentication) {
      this.authentication = authentication.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link OPDSMatchingAuthentication OPDSMatchingAuthentication}.
     * @return An immutable instance of OPDSMatchingAuthentication
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OPDSMatchingAuthentication build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OPDSMatchingAuthentication(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PATTERN_TEXT) != 0) attributes.add("patternText");
      return "Cannot build OPDSMatchingAuthentication, some of required attributes are not set " + attributes;
    }
  }
}
